/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationRouteAware;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.OrderedComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnitOfWorkHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UnitOfWorkHelper.class);

    private UnitOfWorkHelper() {
    }

    public static void doneUow(UnitOfWork uow, Exchange exchange) {
        if (uow == null) {
            return;
        }
        try {
            uow.done(exchange);
        }
        catch (Exception e) {
            LOG.warn("Exception occurred during done UnitOfWork for Exchange: {}. This exception will be ignored.", (Object)exchange.getExchangeId(), (Object)e);
        }
    }

    public static void doneSynchronizations(Exchange exchange, List<Synchronization> synchronizations) {
        if (synchronizations == null || synchronizations.isEmpty()) {
            return;
        }
        if (synchronizations.size() > 1) {
            List<Synchronization> copy2 = UnitOfWorkHelper.safeCopy(synchronizations);
            boolean failed = exchange.isFailed();
            for (Synchronization synchronization : copy2) {
                UnitOfWorkHelper.doneSynchronization(synchronization, exchange, failed);
            }
        } else {
            UnitOfWorkHelper.doneSynchronization(synchronizations.get(0), exchange, exchange.isFailed());
        }
    }

    private static void doneSynchronization(Synchronization synchronization, Exchange exchange, boolean failed) {
        try {
            if (failed) {
                LOG.trace("Invoking synchronization.onFailure: {} with {}", (Object)synchronization, (Object)exchange);
                synchronization.onFailure(exchange);
            } else {
                LOG.trace("Invoking synchronization.onComplete: {} with {}", (Object)synchronization, (Object)exchange);
                synchronization.onComplete(exchange);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception occurred during onCompletion. This exception will be ignored.", (Throwable)e);
        }
    }

    public static void beforeRouteSynchronizations(Route route, Exchange exchange, List<Synchronization> synchronizations, Logger log) {
        List<Synchronization> copy2 = UnitOfWorkHelper.safeCopy(synchronizations);
        UnitOfWorkHelper.invokeSynchronizationCallbacks(route, exchange, log, copy2);
    }

    private static List<Synchronization> safeCopy(List<Synchronization> synchronizations) {
        ArrayList<Synchronization> copy2 = new ArrayList<Synchronization>(synchronizations);
        if (copy2.size() > 1) {
            Collections.reverse(copy2);
            copy2.sort(OrderedComparator.get());
        }
        return copy2;
    }

    private static void invokeSynchronizationCallbacks(Route route, Exchange exchange, Logger log, List<Synchronization> copy2) {
        for (Synchronization synchronization : copy2) {
            SynchronizationRouteAware routeSynchronization = synchronization.getRouteSynchronization();
            if (routeSynchronization == null) continue;
            try {
                log.trace("Invoking synchronization.onBeforeRoute: {} with {}", (Object)synchronization, (Object)exchange);
                routeSynchronization.onBeforeRoute(route, exchange);
            }
            catch (Exception e) {
                log.warn("Exception occurred during onBeforeRoute. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public static void afterRouteSynchronizations(Route route, Exchange exchange, List<Synchronization> synchronizations, Logger log) {
        List<Synchronization> copy2 = UnitOfWorkHelper.safeCopy(synchronizations);
        for (Synchronization synchronization : copy2) {
            SynchronizationRouteAware routeSynchronization = synchronization.getRouteSynchronization();
            if (routeSynchronization == null) continue;
            try {
                log.trace("Invoking synchronization.onAfterRoute: {} with {}", (Object)synchronization, (Object)exchange);
                routeSynchronization.onAfterRoute(route, exchange);
            }
            catch (Exception e) {
                log.warn("Exception occurred during onAfterRoute. This exception will be ignored.", (Throwable)e);
            }
        }
    }
}

