/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.TimeUtils;

public abstract class PropertyConfigurerSupport {
    public static final String MAGIC_VALUE = "@@CamelMagicValue@@";

    public static <T> T property(CamelContext camelContext, Class<T> type2, Object value) {
        String text;
        if (value instanceof String && String.class != type2) {
            text = value.toString();
            if (EndpointHelper.isReferenceParameter(text)) {
                List<Object> obj = type2 == List.class ? EndpointHelper.resolveReferenceListParameter(camelContext, text, Object.class) : EndpointHelper.resolveReferenceParameter(camelContext, text, type2);
                if (obj == null) {
                    throw new NoSuchBeanException(text, type2.getName());
                }
                value = obj;
            } else if (type2 == Long.TYPE || type2 == Long.class || type2 == Integer.TYPE || type2 == Integer.class) {
                Number obj = null;
                try {
                    long num = TimeUtils.toMilliSeconds(text);
                    obj = type2 == Integer.TYPE || type2 == Integer.class ? (Number)((int)num) : (Number)num;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (obj != null) {
                    value = obj;
                }
            }
        }
        if ((type2 == Boolean.class || type2 == Boolean.TYPE) && value instanceof String) {
            text = (String)((Object)value);
            if (!(MAGIC_VALUE.equals(value) || text.equalsIgnoreCase("true") || text.equalsIgnoreCase("false"))) {
                throw new IllegalArgumentException("Cannot convert the String value: " + value + " to type: " + type2 + " as the value is not true or false");
            }
        }
        if (value != null) {
            try {
                if (MAGIC_VALUE.equals(value) && Boolean.TYPE == type2) {
                    value = "true";
                }
                return camelContext.getTypeConverter().mandatoryConvertTo(type2, value);
            }
            catch (NoTypeConversionAvailableException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
        return null;
    }
}

