/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.apache.camel.util.concurrent.Rejectable;
import org.apache.camel.util.concurrent.RejectableFutureTask;

public class RejectableScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    public RejectableScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public RejectableScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory2) {
        super(corePoolSize, threadFactory2);
    }

    public RejectableScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public RejectableScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory2, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory2, handler);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable2, T value) {
        if (runnable2 instanceof Rejectable) {
            return new RejectableFutureTask<T>(runnable2, value);
        }
        return super.newTaskFor(runnable2, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof Rejectable) {
            return new RejectableFutureTask<T>(callable);
        }
        return super.newTaskFor(callable);
    }

    @Override
    public String toString() {
        ThreadFactory threadFactory2 = this.getThreadFactory();
        if (threadFactory2 instanceof CamelThreadFactory) {
            CamelThreadFactory camelThreadFactory = (CamelThreadFactory)threadFactory2;
            String name = camelThreadFactory.getName();
            return super.toString() + "[" + name + "]";
        }
        return super.toString();
    }
}

