/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Bytes;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

public class DefaultFunctionReturnDecoder
extends FunctionReturnDecoder {
    @Override
    public List<Type> decodeFunctionResult(String rawInput, List<TypeReference<Type>> outputParameters) {
        String input = Numeric.cleanHexPrefix(rawInput);
        if (Strings.isEmpty(input)) {
            return Collections.emptyList();
        }
        return DefaultFunctionReturnDecoder.build(input, outputParameters);
    }

    @Override
    public <T extends Type> Type decodeEventParameter(String rawInput, TypeReference<T> typeReference) {
        String input = Numeric.cleanHexPrefix(rawInput);
        try {
            Class<T> type2 = typeReference.getClassType();
            if (Bytes.class.isAssignableFrom(type2)) {
                Class<?> bytesClass = Class.forName(type2.getName());
                return TypeDecoder.decodeBytes(input, bytesClass);
            }
            if (Array.class.isAssignableFrom(type2) || BytesType.class.isAssignableFrom(type2) || Utf8String.class.isAssignableFrom(type2)) {
                return TypeDecoder.decodeBytes(input, Bytes32.class);
            }
            return TypeDecoder.decode(input, type2);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static List<Type> build(String input, List<TypeReference<Type>> outputParameters) {
        ArrayList<Type> results = new ArrayList<Type>(outputParameters.size());
        int offset = 0;
        for (TypeReference<Type> typeReference : outputParameters) {
            try {
                int length;
                Type result2;
                Class<Type> type2 = typeReference.getClassType();
                int hexStringDataOffset = DefaultFunctionReturnDecoder.getDataOffset(input, offset, type2);
                if (DynamicArray.class.isAssignableFrom(type2)) {
                    result2 = TypeDecoder.decodeDynamicArray(input, hexStringDataOffset, typeReference);
                    offset += 64;
                } else if (typeReference instanceof TypeReference.StaticArrayTypeReference) {
                    length = ((TypeReference.StaticArrayTypeReference)typeReference).getSize();
                    result2 = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length);
                    offset += length * 64;
                } else if (StaticArray.class.isAssignableFrom(type2)) {
                    length = Integer.parseInt(type2.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                    result2 = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length);
                    offset += length * 64;
                } else {
                    result2 = TypeDecoder.decode(input, hexStringDataOffset, type2);
                    offset += 64;
                }
                results.add(result2);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Invalid class reference provided", e);
            }
        }
        return results;
    }

    private static <T extends Type> int getDataOffset(String input, int offset, Class<T> type2) {
        if (DynamicBytes.class.isAssignableFrom(type2) || Utf8String.class.isAssignableFrom(type2) || DynamicArray.class.isAssignableFrom(type2)) {
            return TypeDecoder.decodeUintAsInt(input, offset) << 1;
        }
        return offset;
    }
}

