/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Type;

public abstract class Array<T extends Type>
implements Type<List<T>> {
    private final Class<T> type;
    protected final List<T> value;

    @Deprecated
    @SafeVarargs
    Array(String type2, T ... values2) {
        this(type2, Arrays.asList(values2));
    }

    @Deprecated
    Array(String type2, List<T> values2) {
        this(AbiTypes.getType(type2), values2);
    }

    @Deprecated
    Array(String type2) {
        this(type2, (List<T>)new ArrayList());
    }

    @SafeVarargs
    Array(Class<T> type2, T ... values2) {
        this(type2, Arrays.asList(values2));
    }

    Array(Class<T> type2, List<T> values2) {
        this.checkValid(type2, values2);
        this.type = type2;
        this.value = values2;
    }

    @Override
    public List<T> getValue() {
        return this.value;
    }

    public Class<T> getComponentType() {
        return this.type;
    }

    @Override
    public abstract String getTypeAsString();

    private void checkValid(Class<T> type2, List<T> values2) {
        Objects.requireNonNull(type2);
        Objects.requireNonNull(values2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Array array = (Array)o;
        if (!this.type.equals(array.type)) {
            return false;
        }
        return Objects.equals(this.value, array.value);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        return result2;
    }
}

