/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Transaction {
    public static final BigInteger DEFAULT_GAS = BigInteger.valueOf(9000L);
    private String from;
    private String to;
    private BigInteger gas;
    private BigInteger gasPrice;
    private BigInteger value;
    private String data;
    private BigInteger nonce;
    private BigInteger gasPremium;
    private BigInteger feeCap;

    public Transaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data2) {
        this(from, nonce, gasPrice, gasLimit, to, value, data2, null, null);
    }

    public Transaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data2, BigInteger gasPremium, BigInteger feeCap) {
        this.from = from;
        this.to = to;
        this.gas = gasLimit;
        this.gasPrice = gasPrice;
        this.value = value;
        if (data2 != null) {
            this.data = Numeric.prependHexPrefix(data2);
        }
        this.nonce = nonce;
        this.gasPremium = gasPremium;
        this.feeCap = feeCap;
    }

    public static Transaction createContractTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String init) {
        return new Transaction(from, nonce, gasPrice, gasLimit, null, value, init);
    }

    public static Transaction createContractTransaction(String from, BigInteger nonce, BigInteger gasPrice, String init) {
        return Transaction.createContractTransaction(from, nonce, gasPrice, null, null, init);
    }

    public static Transaction createEtherTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value) {
        return new Transaction(from, nonce, gasPrice, gasLimit, to, value, null);
    }

    public static Transaction createFunctionCallTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data2) {
        return new Transaction(from, nonce, gasPrice, gasLimit, to, value, data2);
    }

    public static Transaction createFunctionCallTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data2) {
        return new Transaction(from, nonce, gasPrice, gasLimit, to, null, data2);
    }

    public static Transaction createEthCallTransaction(String from, String to, String data2) {
        return new Transaction(from, null, null, null, to, null, data2);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGas() {
        return Transaction.convert(this.gas);
    }

    public String getGasPrice() {
        return Transaction.convert(this.gasPrice);
    }

    public String getValue() {
        return Transaction.convert(this.value);
    }

    public String getData() {
        return this.data;
    }

    public String getNonce() {
        return Transaction.convert(this.nonce);
    }

    private static String convert(BigInteger value) {
        if (value != null) {
            return Numeric.encodeQuantity(value);
        }
        return null;
    }
}

