/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum.enclave.protocol.utils;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.web3j.quorum.enclave.protocol.utils.Response;
import org.web3j.quorum.enclave.protocol.utils.ResponseParserException;
import org.web3j.quorum.enclave.protocol.utils.StatusCode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/web3j/quorum/enclave/protocol/utils/ResponseParser;", "", "()V", "parseChunkedBody", "", "", "response", "Lorg/web3j/quorum/enclave/protocol/utils/Response;", "parseChunkedResponse", "rawResponse", "parseHeader", "Lkotlin/Pair;", "value", "parseResponse", "parseStatusCode", "Lorg/web3j/quorum/enclave/protocol/utils/StatusCode;", "parseTextPlainBody", "verifyHeader", "", "headerName", "expectedHeaderValue", "verifyResponseCode", "web3j-quorum"})
public final class ResponseParser {
    @NotNull
    public static final ResponseParser INSTANCE = new ResponseParser();

    private ResponseParser() {
    }

    @NotNull
    public final Response parseResponse(@NotNull String response) {
        Intrinsics.checkNotNullParameter(response, "response");
        if (((CharSequence)response).length() == 0) {
            throw new ResponseParserException("Empty response received");
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(response));
        String string = bufferedReader.readLine();
        Intrinsics.checkNotNullExpressionValue(string, "bufferedReader.readLine()");
        StatusCode statusCode = this.parseStatusCode(string);
        HashMap headers = new HashMap();
        String header = bufferedReader.readLine();
        while (true) {
            String string2 = header;
            Intrinsics.checkNotNullExpressionValue(string2, "header");
            if (!(((CharSequence)string2).length() > 0)) break;
            String string3 = header;
            Intrinsics.checkNotNullExpressionValue(string3, "header");
            Pair<String, String> kv = this.parseHeader(string3);
            ((Map)headers).put(kv.getFirst(), kv.getSecond());
            header = bufferedReader.readLine();
        }
        String body = TextStreamsKt.readText(bufferedReader);
        return new Response(statusCode, headers, body);
    }

    private final StatusCode parseStatusCode(String value) {
        Regex regex = new Regex(" ");
        CharSequence charSequence = value;
        int n = 3;
        List<String> params = regex.split(charSequence, n);
        if (params.size() != 3) {
            throw new RuntimeException("Unable to parse status code: " + params);
        }
        int statusCode = Integer.parseInt(params.get(1));
        String message = params.get(2);
        return new StatusCode(statusCode, message);
    }

    private final Pair<String, String> parseHeader(String value) {
        String[] stringArray = new String[]{": "};
        List kv = StringsKt.split$default((CharSequence)value, stringArray, false, 0, 6, null);
        return new Pair<String, String>((String)kv.get(0), (String)kv.get(1));
    }

    @NotNull
    public final String parseTextPlainBody(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        this.verifyHeader("Content-Type", "text/plain; charset=utf-8", response);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(response.getBody()));
        String string = bufferedReader.readLine();
        Intrinsics.checkNotNullExpressionValue(string, "bufferedReader.readLine()");
        return string;
    }

    private final List<String> parseChunkedBody(Response response) {
        this.verifyHeader("Transfer-Encoding", "chunked", response);
        ArrayList<String> chunks = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(response.getBody()));
        String chunkLength = bufferedReader.readLine();
        while (!Intrinsics.areEqual(chunkLength, "0")) {
            int length = Integer.parseInt(chunkLength, 16);
            String chunk = bufferedReader.readLine();
            if (chunk.length() != length) {
                throw new ResponseParserException("Chunk length " + length + " did not match actual");
            }
            chunks.add(chunk);
            chunkLength = bufferedReader.readLine();
        }
        return chunks;
    }

    @NotNull
    public final String parseChunkedResponse(@NotNull String rawResponse) {
        Intrinsics.checkNotNullParameter(rawResponse, "rawResponse");
        Response response = this.parseResponse(rawResponse);
        this.verifyResponseCode(response);
        List<String> chunks = this.parseChunkedBody(response);
        if (chunks.size() == 1) {
            return chunks.get(0);
        }
        if (chunks.isEmpty()) {
            return "";
        }
        throw new ResponseParserException("Multiple chunks (" + chunks.size() + ") returned, expected 1");
    }

    private final void verifyHeader(String headerName, String expectedHeaderValue, Response response) {
        String transferEncoding = response.getHeaders().get(headerName);
        if (!Intrinsics.areEqual(transferEncoding, expectedHeaderValue)) {
            throw new ResponseParserException("Unexpected Transfer-Encoding: " + transferEncoding);
        }
    }

    private final void verifyResponseCode(Response response) {
        if (response.getStatusCode().getCode() != 200) {
            throw new ResponseParserException("Request failed: " + response.getStatusCode());
        }
    }
}

