/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;

public class NoSuchHeaderException
extends CamelExchangeException {
    private final String headerName;
    private final transient Class<?> type;

    public NoSuchHeaderException(String message, Exchange exchange, String headerName) {
        super(message, exchange);
        this.headerName = headerName;
        this.type = null;
    }

    public NoSuchHeaderException(Exchange exchange, String headerName, Class<?> type2) {
        super("No '" + headerName + "' header available" + (String)(type2 != null ? " of type: " + type2.getName() : "") + NoSuchHeaderException.reason(exchange, headerName), exchange);
        this.headerName = headerName;
        this.type = type2;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected static String reason(Exchange exchange, String headerName) {
        Object value = exchange.getMessage().getHeader(headerName);
        return NoSuchHeaderException.valueDescription(value);
    }

    static String valueDescription(Object value) {
        if (value == null) {
            return "";
        }
        return " but has value: " + String.valueOf(value) + " of type: " + value.getClass().getCanonicalName();
    }
}

