/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelException;

public class NoTypeConversionAvailableException
extends CamelException {
    private final transient Object value;
    private final transient Class<?> type;

    public NoTypeConversionAvailableException(Object value, Class<?> type2) {
        super(NoTypeConversionAvailableException.createMessage(value, type2));
        this.value = value;
        this.type = type2;
    }

    public NoTypeConversionAvailableException(Object value, Class<?> type2, Throwable cause) {
        super(NoTypeConversionAvailableException.createMessage(value, type2, cause), cause);
        this.value = value;
        this.type = type2;
    }

    public Object getValue() {
        return this.value;
    }

    public Class<?> getToType() {
        return this.type;
    }

    public Class<?> getFromType() {
        if (this.value != null) {
            return this.value.getClass();
        }
        return null;
    }

    public static String createMessage(Object value, Class<?> type2) {
        return "No type converter available to convert from type: " + (value != null ? value.getClass().getCanonicalName() : null) + " to the required type: " + type2.getCanonicalName();
    }

    public static String createMessage(Object value, Class<?> type2, Throwable cause) {
        return "Converting Exception when converting from type: " + (value != null ? value.getClass().getCanonicalName() : null) + " to the required type: " + type2.getCanonicalName() + ", which is caused by " + String.valueOf(cause);
    }
}

