/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.Objects;

public enum MimeType {
    JSON("application/json"),
    PROTOBUF("application/protobuf"),
    PROTOBUF_BINARY("protobuf/binary"),
    PROTOBUF_STRUCT("protobuf/x-struct"),
    PROTOBUF_JAVA_OBJECT("protobuf/x-java-object"),
    AVRO("application/avro"),
    AVRO_BINARY("avro/binary"),
    AVRO_STRUCT("avro/x-struct"),
    AVRO_JAVA_OBJECT("avro/x-java-object"),
    BINARY("application/octet-stream"),
    TEXT("text/plain"),
    JAVA_OBJECT("application/x-java-object"),
    STRUCT("application/x-struct");

    private static final MimeType[] VALUES;
    private final String type;

    private MimeType(String type2) {
        this.type = type2;
    }

    public String type() {
        return this.type;
    }

    public static MimeType of(String type2) {
        for (MimeType mt : VALUES) {
            if (!Objects.equals(type2, mt.type)) continue;
            return mt;
        }
        throw new IllegalArgumentException("Unsupported type: " + type2);
    }

    static {
        VALUES = MimeType.values();
    }
}

