/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.LocalBeanRepositoryAware;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SimpleRegistry;
import org.apache.camel.support.SupplierRegistry;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.function.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegistry
extends ServiceSupport
implements Registry,
LocalBeanRepositoryAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRegistry.class);
    protected CamelContext camelContext;
    protected final ThreadLocal<BeanRepository> localRepository = new ThreadLocal();
    protected volatile boolean localRepositoryEnabled;
    protected List<BeanRepository> repositories;
    protected Registry fallbackRegistry = new SimpleRegistry();
    protected Registry supplierRegistry = new SupplierRegistry();
    protected final Map<String, KeyValueHolder<Object, String>> beansToDestroy = new LinkedHashMap<String, KeyValueHolder<Object, String>>();

    public DefaultRegistry() {
    }

    public DefaultRegistry(BeanRepository ... repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(Arrays.asList(repositories));
        }
    }

    public DefaultRegistry(Collection<BeanRepository> repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(repositories);
        }
    }

    @Override
    public void setLocalBeanRepository(BeanRepository repository) {
        if (repository != null) {
            this.localRepository.set(repository);
            this.localRepositoryEnabled = true;
        } else {
            BeanRepository old = this.localRepository.get();
            if (old != null) {
                ServiceHelper.stopService((Object)old);
            }
            this.localRepository.remove();
            this.localRepositoryEnabled = false;
        }
    }

    @Override
    public BeanRepository getLocalBeanRepository() {
        return this.localRepositoryEnabled ? this.localRepository.get() : null;
    }

    public Registry getFallbackRegistry() {
        return this.fallbackRegistry;
    }

    public void setFallbackRegistry(Registry fallbackRegistry) {
        this.fallbackRegistry = fallbackRegistry;
    }

    public Registry getSupplierRegistry() {
        return this.supplierRegistry;
    }

    public void setSupplierRegistry(Registry supplierRegistry) {
        this.supplierRegistry = supplierRegistry;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<BeanRepository> getRepositories() {
        if (this.repositories == null) {
            return null;
        }
        return Collections.unmodifiableList(this.repositories);
    }

    public void addBeanRepository(BeanRepository repository) {
        if (repository == null) {
            this.repositories = new ArrayList<BeanRepository>();
        }
        this.repositories.add(repository);
    }

    @Override
    public void bind(String id, Class<?> type2, Object bean) throws RuntimeCamelException {
        this.bind(id, type2, bean, null, null);
    }

    @Override
    public void bind(String id, Class<?> type2, Object bean, String initMethod, String destroyMethod) throws RuntimeCamelException {
        if (bean != null) {
            CamelContextAware.trySetCamelContext(bean, this.camelContext);
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(initMethod)) {
                try {
                    ObjectHelper.invokeMethodSafe(initMethod, bean, new Object[0]);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(e);
                }
            }
            this.fallbackRegistry.bind(id, type2, bean);
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(destroyMethod)) {
                this.beansToDestroy.put(id, new KeyValueHolder<Object, String>(bean, destroyMethod));
            }
        }
    }

    @Override
    public void bind(String id, Class<?> type2, Supplier<Object> bean) throws RuntimeCamelException {
        if (bean != null) {
            this.supplierRegistry.bind(id, type2, Suppliers.memorize(bean));
        }
    }

    @Override
    public void bindAsPrototype(String id, Class<?> type2, Supplier<Object> bean) throws RuntimeCamelException {
        if (bean != null) {
            this.supplierRegistry.bind(id, type2, bean);
        }
    }

    @Override
    public void unbind(String id) {
        this.supplierRegistry.unbind(id);
        this.fallbackRegistry.unbind(id);
        this.destroyBean(id, true);
    }

    protected void destroyBean(String name, boolean remove) {
        KeyValueHolder<Object, String> holder;
        KeyValueHolder<Object, String> keyValueHolder = holder = remove ? this.beansToDestroy.remove(name) : this.beansToDestroy.get(name);
        if (holder != null) {
            String destroyMethod = holder.getValue();
            Object target = holder.getKey();
            try {
                ObjectHelper.invokeMethodSafe(destroyMethod, target, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Error invoking destroy method: {} on bean: {} due to: {}. This exception is ignored.", new Object[]{destroyMethod, target, e.getMessage(), e});
            }
        }
    }

    @Override
    public Object lookupByName(String name) {
        Object answer;
        BeanRepository local;
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        BeanRepository beanRepository = local = this.localRepositoryEnabled ? this.localRepository.get() : null;
        if (local != null && (answer = local.lookupByName(name)) != null) {
            return this.unwrap(answer);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                answer = r.lookupByName(name);
                if (answer == null) continue;
                return this.unwrap(answer);
            }
        }
        if ((answer = this.supplierRegistry.lookupByName(name)) == null) {
            answer = this.fallbackRegistry.lookupByName(name);
        }
        if (answer != null) {
            answer = this.unwrap(answer);
        }
        return answer;
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type2) {
        Object answer;
        BeanRepository local;
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        BeanRepository beanRepository = local = this.localRepositoryEnabled ? this.localRepository.get() : null;
        if (local != null && (answer = local.lookupByNameAndType(name, type2)) != null) {
            return (T)this.unwrap(answer);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                answer = r.lookupByNameAndType(name, type2);
                if (answer == null) continue;
                return (T)this.unwrap(answer);
            }
        }
        if ((answer = this.supplierRegistry.lookupByNameAndType(name, type2)) == null) {
            answer = this.fallbackRegistry.lookupByNameAndType(name, type2);
        }
        if (answer != null) {
            answer = this.unwrap(answer);
        }
        return answer;
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type2) {
        Map<String, T> found;
        BeanRepository local;
        LinkedHashMap<String, T> answer = new LinkedHashMap<String, T>();
        BeanRepository beanRepository = local = this.localRepositoryEnabled ? this.localRepository.get() : null;
        if (local != null && (found = local.findByTypeWithName(type2)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        if (this.repositories != null) {
            found = this.repositories.iterator();
            while (found.hasNext()) {
                BeanRepository r = (BeanRepository)found.next();
                Map<String, T> found2 = r.findByTypeWithName(type2);
                if (found2 == null || found2.isEmpty()) continue;
                answer.putAll(found2);
            }
        }
        if ((found = this.supplierRegistry.findByTypeWithName(type2)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        if ((found = this.fallbackRegistry.findByTypeWithName(type2)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        return answer;
    }

    @Override
    public <T> Set<T> findByType(Class<T> type2) {
        Set<T> found;
        BeanRepository local;
        LinkedHashSet<T> answer = new LinkedHashSet<T>();
        BeanRepository beanRepository = local = this.localRepositoryEnabled ? this.localRepository.get() : null;
        if (local != null && (found = local.findByType(type2)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        if (this.repositories != null) {
            found = this.repositories.iterator();
            while (found.hasNext()) {
                BeanRepository r = (BeanRepository)found.next();
                Set<T> found2 = r.findByType(type2);
                if (found2 == null || found2.isEmpty()) continue;
                answer.addAll(found2);
            }
        }
        if ((found = this.supplierRegistry.findByType(type2)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        if ((found = this.fallbackRegistry.findByType(type2)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        return answer;
    }

    @Override
    public <T> T findSingleByType(Class<T> type2) {
        BeanRepository local;
        T found = null;
        BeanRepository beanRepository = local = this.localRepositoryEnabled ? this.localRepository.get() : null;
        if (local != null) {
            found = local.findSingleByType(type2);
        }
        if (found == null && this.repositories != null) {
            BeanRepository r;
            Iterator<BeanRepository> iterator2 = this.repositories.iterator();
            while (iterator2.hasNext() && (found = (T)(r = iterator2.next()).findSingleByType(type2)) == null) {
            }
        }
        if (found == null) {
            found = this.supplierRegistry.findSingleByType(type2);
        }
        if (found == null) {
            found = this.fallbackRegistry.findSingleByType(type2);
        }
        return found;
    }

    @Override
    protected void doStop() throws Exception {
        Closeable closeable;
        super.doStop();
        Registry registry = this.supplierRegistry;
        if (registry instanceof Closeable) {
            closeable = (Closeable)((Object)registry);
            IOHelper.close(closeable);
        }
        if ((registry = this.fallbackRegistry) instanceof Closeable) {
            closeable = (Closeable)((Object)registry);
            IOHelper.close(closeable);
        }
        ServiceHelper.stopAndShutdownServices(this.supplierRegistry, this.fallbackRegistry);
        for (String name : this.beansToDestroy.keySet()) {
            this.destroyBean(name, false);
        }
        this.beansToDestroy.clear();
    }
}

