/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;

public final class InputStreamIterator
extends InputStream {
    private final TypeConverter converter;
    private final Iterator<?> it;
    private InputStream chunk;

    public InputStreamIterator(TypeConverter converter, Iterator<?> it) {
        this.converter = converter;
        this.it = it;
    }

    @Override
    public int read() throws IOException {
        if (this.chunk == null) {
            this.chunk = this.nextChunk();
        }
        if (this.chunk == null) {
            return -1;
        }
        int data2 = this.chunk.read();
        if (data2 == -1) {
            this.chunk = null;
            return this.read();
        }
        return data2;
    }

    @Override
    public int available() throws IOException {
        if (this.chunk == null) {
            this.chunk = this.nextChunk();
        }
        return this.chunk != null ? this.chunk.available() : 0;
    }

    private InputStream nextChunk() throws IOException {
        if (this.it.hasNext()) {
            try {
                byte[] buf = this.converter.mandatoryConvertTo(byte[].class, this.it.next());
                return new ByteArrayInputStream(buf);
            }
            catch (NoTypeConversionAvailableException e) {
                throw new IOException(e);
            }
        }
        return null;
    }
}

