/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.URISupport;

public class ScheduledPollConsumerHealthCheck
implements HealthCheck {
    private final HealthCheckRegistry registry;
    private HealthCheck.State initialState;
    private final ScheduledPollConsumer consumer;
    private final String id;
    private final String sanitizedBaseUri;
    private final String sanitizedUri;
    private boolean enabled = true;

    public ScheduledPollConsumerHealthCheck(ScheduledPollConsumer consumer, String id) {
        this.registry = HealthCheckRegistry.get(consumer.getEndpoint().getCamelContext());
        this.initialState = this.registry != null ? this.registry.getInitialState() : HealthCheck.State.DOWN;
        this.consumer = consumer;
        this.id = id;
        this.sanitizedBaseUri = URISupport.sanitizeUri(consumer.getEndpoint().getEndpointBaseUri());
        this.sanitizedUri = URISupport.sanitizeUri(consumer.getEndpoint().getEndpointUri());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public HealthCheck.Result call(Map<String, Object> options2) {
        HealthCheckResultBuilder builder = HealthCheckResultBuilder.on(this);
        builder.state(this.initialState);
        builder.detail("endpoint.uri", this.sanitizedUri);
        HealthCheck.Kind kind = this.isLiveness() && this.isReadiness() ? (HealthCheck.Kind)((Object)options2.getOrDefault("check.kind", (Object)HealthCheck.Kind.ALL)) : (this.isLiveness() ? HealthCheck.Kind.LIVENESS : HealthCheck.Kind.READINESS);
        builder.detail("check.kind", (Object)kind);
        if (!this.isEnabled()) {
            builder.message("Disabled");
            builder.detail("check.enabled", false);
            return builder.unknown().build();
        }
        long ec = this.consumer.getErrorCounter();
        boolean ready = this.consumer.isConsumerReady();
        Throwable cause = this.consumer.getLastError();
        boolean healthy = ec == 0L;
        boolean readiness = kind.equals((Object)HealthCheck.Kind.READINESS);
        if (readiness && !ready) {
            boolean down = builder.state().equals((Object)HealthCheck.State.DOWN);
            if (!down) {
                return builder.build();
            }
            healthy = false;
        }
        if (healthy) {
            builder.up();
        } else {
            builder.down();
            builder.detail("failure.error.count", ec);
            String rid = this.consumer.getRouteId();
            if (ec > 0L) {
                String msg = "Consumer failed polling %s times route: %s (%s)";
                builder.message(String.format(msg, ec, rid, this.sanitizedBaseUri));
            } else {
                String msg = "Consumer has not yet polled route: %s (%s)";
                builder.message(String.format(msg, rid, this.sanitizedBaseUri));
            }
            builder.error(cause);
            if (this.consumer.getLastErrorDetails() != null) {
                builder.details(this.consumer.getLastErrorDetails());
            }
        }
        return builder.build();
    }

    public HealthCheck.State getInitialState() {
        return this.initialState;
    }

    public void setInitialState(HealthCheck.State initialState) {
        this.initialState = initialState;
    }

    @Override
    public String getGroup() {
        return "camel";
    }

    @Override
    public String getId() {
        return this.id;
    }
}

