/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.component.RawParameterHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public abstract class SendDynamicAwareSupport
extends ServiceSupport
implements SendDynamicAware {
    private CamelContext camelContext;
    private Set<String> knownProperties;
    private Set<String> knownPrefixes;
    private String scheme;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public boolean resolveRawParameterValues() {
        return true;
    }

    @Override
    protected void doInit() throws Exception {
        if (this.knownProperties == null || this.knownPrefixes == null) {
            EndpointUriFactory factory = this.getCamelContext().getCamelContextExtension().getEndpointUriFactory(this.getScheme());
            if (factory == null) {
                throw new IllegalStateException("Cannot find EndpointUriFactory for component: " + this.getScheme());
            }
            this.knownProperties = factory.propertyNames();
            this.knownPrefixes = factory.multiValuePrefixes();
        }
    }

    public Map<String, Object> endpointProperties(Exchange exchange, String uri) throws Exception {
        Map<String, Object> properties2;
        Map<String, Object> map = URISupport.parseQuery(URISupport.extractQuery(uri));
        if (map != null && !map.isEmpty() && this.isLenientProperties()) {
            if (this.resolveRawParameterValues()) {
                RawParameterHelper.resolveRawParameterValues(exchange.getContext(), map);
            }
            properties2 = new LinkedHashMap<String, Object>();
            map.forEach((k, v) -> {
                boolean accept = this.knownProperties.contains(k);
                if (!accept && !this.knownPrefixes.isEmpty()) {
                    accept = this.knownPrefixes.stream().anyMatch(k::startsWith);
                }
                if (accept) {
                    properties2.put((String)k, v);
                }
            });
        } else {
            properties2 = map;
        }
        return properties2;
    }

    public Map<String, Object> endpointLenientProperties(Exchange exchange, String uri) throws Exception {
        Map<String, Object> properties2;
        Map<String, Object> map = URISupport.parseQuery(URISupport.extractQuery(uri));
        if (map != null && !map.isEmpty()) {
            if (this.resolveRawParameterValues()) {
                RawParameterHelper.resolveRawParameterValues(exchange.getContext(), map);
            }
            properties2 = new LinkedHashMap<String, Object>();
            map.forEach((k, v) -> {
                boolean accept;
                boolean bl = accept = !this.knownProperties.contains(k);
                if (accept && !this.knownPrefixes.isEmpty()) {
                    accept = this.knownPrefixes.stream().noneMatch(k::startsWith);
                }
                if (accept) {
                    properties2.put((String)k, v.toString());
                }
            });
        } else {
            properties2 = map;
        }
        return properties2;
    }

    public String asEndpointUri(Exchange exchange, String uri, Map<String, Object> properties2) throws Exception {
        String query = URISupport.createQueryString(properties2, false);
        return StringHelper.before(uri, "?", uri) + "?" + query;
    }
}

