/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.camel.util.ObjectHelper;

public final class PropertiesHelper {
    private PropertiesHelper() {
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties2, String optionPrefix) {
        return PropertiesHelper.extractProperties(properties2, optionPrefix, true);
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties2, String optionPrefix, boolean remove) {
        if (properties2 == null) {
            return new LinkedHashMap<String, Object>(0);
        }
        return PropertiesHelper.doExtractProperties(properties2, optionPrefix, remove);
    }

    static Map<String, Object> doExtractProperties(Map<String, Object> properties2, String optionPrefix, boolean remove) {
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties2.size());
        Iterator<Map.Entry<String, Object>> it = properties2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties2.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            if (!remove) continue;
            it.remove();
        }
        return rc;
    }

    public static boolean hasProperties(Map<String, Object> properties2, String optionPrefix) {
        ObjectHelper.notNull(properties2, "properties");
        if (ObjectHelper.isNotEmpty(optionPrefix)) {
            for (String o : properties2.keySet()) {
                String name = o;
                if (!name.startsWith(optionPrefix)) continue;
                return true;
            }
            return false;
        }
        return !properties2.isEmpty();
    }

    public static Properties asProperties(String ... properties2) {
        if ((properties2.length & 1) != 0) {
            throw new InternalError("length is odd");
        }
        Properties answer = new Properties();
        for (int i = 0; i < properties2.length; i += 2) {
            answer.setProperty(Objects.requireNonNull(properties2[i]), Objects.requireNonNull(properties2[i + 1]));
        }
        return answer;
    }

    public static Properties asProperties(Map<String, Object> properties2) {
        Properties answer = new Properties();
        answer.putAll(properties2);
        return answer;
    }
}

