/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.util.List;
import java.util.stream.Collectors;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public class EventEncoder {
    private EventEncoder() {
    }

    public static String encode(Event event) {
        String methodSignature = EventEncoder.buildMethodSignature(event.getName(), event.getParameters());
        return EventEncoder.buildEventSignature(methodSignature);
    }

    static <T extends Type> String buildMethodSignature(String methodName, List<TypeReference<T>> parameters2) {
        StringBuilder result2 = new StringBuilder();
        result2.append(methodName);
        result2.append("(");
        String params = parameters2.stream().map(p -> Utils.getTypeName(p)).collect(Collectors.joining(","));
        result2.append(params);
        result2.append(")");
        return result2.toString();
    }

    public static String buildEventSignature(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = Hash.sha3(input);
        return Numeric.toHexString(hash);
    }
}

