/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.bouncycastle.math.ec.ECPoint;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class Bip32ECKeyPair
extends ECKeyPair {
    public static final int HARDENED_BIT = Integer.MIN_VALUE;
    private final boolean parentHasPrivate;
    private final int childNumber;
    private final int depth;
    private final byte[] chainCode;
    private int parentFingerprint;
    private ECPoint publicKeyPoint;

    public Bip32ECKeyPair(BigInteger privateKey, BigInteger publicKey, int childNumber, byte[] chainCode, Bip32ECKeyPair parent) {
        super(privateKey, publicKey);
        this.parentHasPrivate = parent != null && parent.hasPrivateKey();
        this.childNumber = childNumber;
        this.depth = parent == null ? 0 : parent.depth + 1;
        this.chainCode = Arrays.copyOf(chainCode, chainCode.length);
        this.parentFingerprint = parent != null ? parent.getFingerprint() : 0;
    }

    public static Bip32ECKeyPair create(BigInteger privateKey, byte[] chainCode) {
        return new Bip32ECKeyPair(privateKey, Sign.publicKeyFromPrivate(privateKey), 0, chainCode, null);
    }

    public static Bip32ECKeyPair create(byte[] privateKey, byte[] chainCode) {
        return Bip32ECKeyPair.create(Numeric.toBigInt(privateKey), chainCode);
    }

    public static Bip32ECKeyPair generateKeyPair(byte[] seed) {
        byte[] i = Hash.hmacSha512("Bitcoin seed".getBytes(), seed);
        byte[] il = Arrays.copyOfRange(i, 0, 32);
        byte[] ir = Arrays.copyOfRange(i, 32, 64);
        Arrays.fill(i, (byte)0);
        Bip32ECKeyPair keypair = Bip32ECKeyPair.create(il, ir);
        Arrays.fill(il, (byte)0);
        Arrays.fill(ir, (byte)0);
        return keypair;
    }

    public static Bip32ECKeyPair deriveKeyPair(Bip32ECKeyPair master, int[] path) {
        Bip32ECKeyPair curr = master;
        if (path != null) {
            for (int childNumber : path) {
                curr = curr.deriveChildKey(childNumber);
            }
        }
        return curr;
    }

    private Bip32ECKeyPair deriveChildKey(int childNumber) {
        if (!this.hasPrivateKey()) {
            byte[] parentPublicKey = this.getPublicKeyPoint().getEncoded(true);
            ByteBuffer data2 = ByteBuffer.allocate(37);
            data2.put(parentPublicKey);
            data2.putInt(childNumber);
            byte[] i = Hash.hmacSha512(this.getChainCode(), data2.array());
            byte[] il = Arrays.copyOfRange(i, 0, 32);
            byte[] chainCode = Arrays.copyOfRange(i, 32, 64);
            Arrays.fill(i, (byte)0);
            BigInteger ilInt = new BigInteger(1, il);
            Arrays.fill(il, (byte)0);
            ECPoint ki = Sign.publicPointFromPrivate(ilInt).add(this.getPublicKeyPoint());
            return new Bip32ECKeyPair(null, Sign.publicFromPoint(ki.getEncoded(true)), childNumber, chainCode, this);
        }
        ByteBuffer data3 = ByteBuffer.allocate(37);
        if (Bip32ECKeyPair.isHardened(childNumber)) {
            data3.put(this.getPrivateKeyBytes33());
        } else {
            byte[] parentPublicKey = this.getPublicKeyPoint().getEncoded(true);
            data3.put(parentPublicKey);
        }
        data3.putInt(childNumber);
        byte[] i = Hash.hmacSha512(this.getChainCode(), data3.array());
        byte[] il = Arrays.copyOfRange(i, 0, 32);
        byte[] chainCode = Arrays.copyOfRange(i, 32, 64);
        Arrays.fill(i, (byte)0);
        BigInteger ilInt = new BigInteger(1, il);
        Arrays.fill(il, (byte)0);
        BigInteger privateKey = this.getPrivateKey().add(ilInt).mod(Sign.CURVE.getN());
        return new Bip32ECKeyPair(privateKey, Sign.publicKeyFromPrivate(privateKey), childNumber, chainCode, this);
    }

    private int getFingerprint() {
        byte[] id = this.getIdentifier();
        return id[3] & 0xFF | (id[2] & 0xFF) << 8 | (id[1] & 0xFF) << 16 | (id[0] & 0xFF) << 24;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getParentFingerprint() {
        return this.parentFingerprint;
    }

    public byte[] getChainCode() {
        return this.chainCode;
    }

    public int getChildNumber() {
        return this.childNumber;
    }

    private byte[] getIdentifier() {
        return Hash.sha256hash160(this.getPublicKeyPoint().getEncoded(true));
    }

    public ECPoint getPublicKeyPoint() {
        if (this.publicKeyPoint == null) {
            this.publicKeyPoint = Sign.publicPointFromPrivate(this.getPrivateKey());
        }
        return this.publicKeyPoint;
    }

    public byte[] getPrivateKeyBytes33() {
        int numBytes = 33;
        byte[] bytes33 = new byte[33];
        byte[] priv = Bip32ECKeyPair.bigIntegerToBytes32(this.getPrivateKey());
        System.arraycopy(priv, 0, bytes33, 33 - priv.length, priv.length);
        return bytes33;
    }

    private boolean hasPrivateKey() {
        return this.getPrivateKey() != null || this.parentHasPrivate;
    }

    private static byte[] bigIntegerToBytes32(BigInteger b) {
        int numBytes = 32;
        byte[] src = b.toByteArray();
        byte[] dest = new byte[32];
        boolean isFirstByteOnlyForSign = src[0] == 0;
        int length = isFirstByteOnlyForSign ? src.length - 1 : src.length;
        int srcPos = isFirstByteOnlyForSign ? 1 : 0;
        int destPos = 32 - length;
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    private static boolean isHardened(int a) {
        return (a & Integer.MIN_VALUE) != 0;
    }
}

