/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.ens;

import java.net.IDN;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.web3j.crypto.Hash;
import org.web3j.ens.EnsResolutionException;
import org.web3j.utils.Numeric;

public class NameHash {
    private static final byte[] EMPTY = new byte[32];

    public static byte[] nameHashAsBytes(String ensName) {
        return Numeric.hexStringToByteArray(NameHash.nameHash(ensName));
    }

    public static String nameHash(String ensName) {
        String normalisedEnsName = NameHash.normalise(ensName);
        return Numeric.toHexString(NameHash.nameHash(normalisedEnsName.split("\\.")));
    }

    private static byte[] nameHash(String[] labels) {
        if (labels.length == 0 || labels[0].equals("")) {
            return EMPTY;
        }
        String[] tail = labels.length == 1 ? new String[]{} : Arrays.copyOfRange(labels, 1, labels.length);
        byte[] remainderHash = NameHash.nameHash(tail);
        byte[] result2 = Arrays.copyOf(remainderHash, 64);
        byte[] labelHash = Hash.sha3(labels[0].getBytes(StandardCharsets.UTF_8));
        System.arraycopy(labelHash, 0, result2, 32, labelHash.length);
        return Hash.sha3(result2);
    }

    public static String normalise(String ensName) {
        try {
            return IDN.toASCII(ensName, 2).toLowerCase();
        }
        catch (IllegalArgumentException e) {
            throw new EnsResolutionException("Invalid ENS name provided: " + ensName);
        }
    }
}

