/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core;

import io.reactivex.Flowable;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.BatchRequest;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.request.ShhFilter;
import org.web3j.protocol.core.methods.request.ShhPost;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.DbGetHex;
import org.web3j.protocol.core.methods.response.DbGetString;
import org.web3j.protocol.core.methods.response.DbPutHex;
import org.web3j.protocol.core.methods.response.DbPutString;
import org.web3j.protocol.core.methods.response.EthAccounts;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthCoinbase;
import org.web3j.protocol.core.methods.response.EthCompileLLL;
import org.web3j.protocol.core.methods.response.EthCompileSerpent;
import org.web3j.protocol.core.methods.response.EthCompileSolidity;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByHash;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByNumber;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetCompilers;
import org.web3j.protocol.core.methods.response.EthGetStorageAt;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthGetUncleCountByBlockHash;
import org.web3j.protocol.core.methods.response.EthGetUncleCountByBlockNumber;
import org.web3j.protocol.core.methods.response.EthGetWork;
import org.web3j.protocol.core.methods.response.EthHashrate;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.EthMining;
import org.web3j.protocol.core.methods.response.EthProtocolVersion;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthSign;
import org.web3j.protocol.core.methods.response.EthSubmitHashrate;
import org.web3j.protocol.core.methods.response.EthSubmitWork;
import org.web3j.protocol.core.methods.response.EthSubscribe;
import org.web3j.protocol.core.methods.response.EthSyncing;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.EthUninstallFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.NetListening;
import org.web3j.protocol.core.methods.response.NetPeerCount;
import org.web3j.protocol.core.methods.response.NetVersion;
import org.web3j.protocol.core.methods.response.ShhAddToGroup;
import org.web3j.protocol.core.methods.response.ShhHasIdentity;
import org.web3j.protocol.core.methods.response.ShhMessages;
import org.web3j.protocol.core.methods.response.ShhNewFilter;
import org.web3j.protocol.core.methods.response.ShhNewGroup;
import org.web3j.protocol.core.methods.response.ShhNewIdentity;
import org.web3j.protocol.core.methods.response.ShhUninstallFilter;
import org.web3j.protocol.core.methods.response.ShhVersion;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.core.methods.response.Web3Sha3;
import org.web3j.protocol.core.methods.response.admin.AdminNodeInfo;
import org.web3j.protocol.core.methods.response.admin.AdminPeers;
import org.web3j.protocol.rx.JsonRpc2_0Rx;
import org.web3j.protocol.websocket.events.LogNotification;
import org.web3j.protocol.websocket.events.NewHeadsNotification;
import org.web3j.utils.Async;
import org.web3j.utils.Numeric;

public class JsonRpc2_0Web3j
implements Web3j {
    public static final int DEFAULT_BLOCK_TIME = 15000;
    protected final Web3jService web3jService;
    private final JsonRpc2_0Rx web3jRx;
    private final long blockTime;
    private final ScheduledExecutorService scheduledExecutorService;

    public JsonRpc2_0Web3j(Web3jService web3jService) {
        this(web3jService, 15000L, Async.defaultExecutorService());
    }

    public JsonRpc2_0Web3j(Web3jService web3jService, long pollingInterval, ScheduledExecutorService scheduledExecutorService) {
        this.web3jService = web3jService;
        this.web3jRx = new JsonRpc2_0Rx(this, scheduledExecutorService);
        this.blockTime = pollingInterval;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public Request<?, Web3ClientVersion> web3ClientVersion() {
        return new Request("web3_clientVersion", Collections.emptyList(), this.web3jService, Web3ClientVersion.class);
    }

    @Override
    public Request<?, Web3Sha3> web3Sha3(String data2) {
        return new Request<String, Web3Sha3>("web3_sha3", Arrays.asList(data2), this.web3jService, Web3Sha3.class);
    }

    @Override
    public Request<?, NetVersion> netVersion() {
        return new Request("net_version", Collections.emptyList(), this.web3jService, NetVersion.class);
    }

    @Override
    public Request<?, NetListening> netListening() {
        return new Request("net_listening", Collections.emptyList(), this.web3jService, NetListening.class);
    }

    @Override
    public Request<?, NetPeerCount> netPeerCount() {
        return new Request("net_peerCount", Collections.emptyList(), this.web3jService, NetPeerCount.class);
    }

    @Override
    public Request<?, AdminNodeInfo> adminNodeInfo() {
        return new Request("admin_nodeInfo", Collections.emptyList(), this.web3jService, AdminNodeInfo.class);
    }

    @Override
    public Request<?, AdminPeers> adminPeers() {
        return new Request("admin_peers", Collections.emptyList(), this.web3jService, AdminPeers.class);
    }

    @Override
    public Request<?, EthProtocolVersion> ethProtocolVersion() {
        return new Request("eth_protocolVersion", Collections.emptyList(), this.web3jService, EthProtocolVersion.class);
    }

    @Override
    public Request<?, EthChainId> ethChainId() {
        return new Request("eth_chainId", Collections.emptyList(), this.web3jService, EthChainId.class);
    }

    @Override
    public Request<?, EthCoinbase> ethCoinbase() {
        return new Request("eth_coinbase", Collections.emptyList(), this.web3jService, EthCoinbase.class);
    }

    @Override
    public Request<?, EthSyncing> ethSyncing() {
        return new Request("eth_syncing", Collections.emptyList(), this.web3jService, EthSyncing.class);
    }

    @Override
    public Request<?, EthMining> ethMining() {
        return new Request("eth_mining", Collections.emptyList(), this.web3jService, EthMining.class);
    }

    @Override
    public Request<?, EthHashrate> ethHashrate() {
        return new Request("eth_hashrate", Collections.emptyList(), this.web3jService, EthHashrate.class);
    }

    @Override
    public Request<?, EthGasPrice> ethGasPrice() {
        return new Request("eth_gasPrice", Collections.emptyList(), this.web3jService, EthGasPrice.class);
    }

    @Override
    public Request<?, EthAccounts> ethAccounts() {
        return new Request("eth_accounts", Collections.emptyList(), this.web3jService, EthAccounts.class);
    }

    @Override
    public Request<?, EthBlockNumber> ethBlockNumber() {
        return new Request("eth_blockNumber", Collections.emptyList(), this.web3jService, EthBlockNumber.class);
    }

    @Override
    public Request<?, EthGetBalance> ethGetBalance(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, EthGetBalance>("eth_getBalance", Arrays.asList(address, defaultBlockParameter.getValue()), this.web3jService, EthGetBalance.class);
    }

    @Override
    public Request<?, EthGetStorageAt> ethGetStorageAt(String address, BigInteger position, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, EthGetStorageAt>("eth_getStorageAt", Arrays.asList(address, Numeric.encodeQuantity(position), defaultBlockParameter.getValue()), this.web3jService, EthGetStorageAt.class);
    }

    @Override
    public Request<?, EthGetTransactionCount> ethGetTransactionCount(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, EthGetTransactionCount>("eth_getTransactionCount", Arrays.asList(address, defaultBlockParameter.getValue()), this.web3jService, EthGetTransactionCount.class);
    }

    @Override
    public Request<?, EthGetBlockTransactionCountByHash> ethGetBlockTransactionCountByHash(String blockHash) {
        return new Request<String, EthGetBlockTransactionCountByHash>("eth_getBlockTransactionCountByHash", Arrays.asList(blockHash), this.web3jService, EthGetBlockTransactionCountByHash.class);
    }

    @Override
    public Request<?, EthGetBlockTransactionCountByNumber> ethGetBlockTransactionCountByNumber(DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, EthGetBlockTransactionCountByNumber>("eth_getBlockTransactionCountByNumber", Arrays.asList(defaultBlockParameter.getValue()), this.web3jService, EthGetBlockTransactionCountByNumber.class);
    }

    @Override
    public Request<?, EthGetUncleCountByBlockHash> ethGetUncleCountByBlockHash(String blockHash) {
        return new Request<String, EthGetUncleCountByBlockHash>("eth_getUncleCountByBlockHash", Arrays.asList(blockHash), this.web3jService, EthGetUncleCountByBlockHash.class);
    }

    @Override
    public Request<?, EthGetUncleCountByBlockNumber> ethGetUncleCountByBlockNumber(DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, EthGetUncleCountByBlockNumber>("eth_getUncleCountByBlockNumber", Arrays.asList(defaultBlockParameter.getValue()), this.web3jService, EthGetUncleCountByBlockNumber.class);
    }

    @Override
    public Request<?, EthGetCode> ethGetCode(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, EthGetCode>("eth_getCode", Arrays.asList(address, defaultBlockParameter.getValue()), this.web3jService, EthGetCode.class);
    }

    @Override
    public Request<?, EthSign> ethSign(String address, String sha3HashOfDataToSign) {
        return new Request<String, EthSign>("eth_sign", Arrays.asList(address, sha3HashOfDataToSign), this.web3jService, EthSign.class);
    }

    @Override
    public Request<?, EthSendTransaction> ethSendTransaction(Transaction transaction) {
        return new Request<Transaction, EthSendTransaction>("eth_sendTransaction", Arrays.asList(transaction), this.web3jService, EthSendTransaction.class);
    }

    @Override
    public Request<?, EthSendTransaction> ethSendRawTransaction(String signedTransactionData) {
        return new Request<String, EthSendTransaction>("eth_sendRawTransaction", Arrays.asList(signedTransactionData), this.web3jService, EthSendTransaction.class);
    }

    @Override
    public Request<?, EthCall> ethCall(Transaction transaction, DefaultBlockParameter defaultBlockParameter) {
        return new Request<Object, EthCall>("eth_call", Arrays.asList(transaction, defaultBlockParameter), this.web3jService, EthCall.class);
    }

    @Override
    public Request<?, EthEstimateGas> ethEstimateGas(Transaction transaction) {
        return new Request<Transaction, EthEstimateGas>("eth_estimateGas", Arrays.asList(transaction), this.web3jService, EthEstimateGas.class);
    }

    @Override
    public Request<?, EthBlock> ethGetBlockByHash(String blockHash, boolean returnFullTransactionObjects) {
        return new Request<Serializable, EthBlock>("eth_getBlockByHash", Arrays.asList(blockHash, returnFullTransactionObjects), this.web3jService, EthBlock.class);
    }

    @Override
    public Request<?, EthBlock> ethGetBlockByNumber(DefaultBlockParameter defaultBlockParameter, boolean returnFullTransactionObjects) {
        return new Request<Serializable, EthBlock>("eth_getBlockByNumber", Arrays.asList(defaultBlockParameter.getValue(), returnFullTransactionObjects), this.web3jService, EthBlock.class);
    }

    @Override
    public Request<?, EthTransaction> ethGetTransactionByHash(String transactionHash) {
        return new Request<String, EthTransaction>("eth_getTransactionByHash", Arrays.asList(transactionHash), this.web3jService, EthTransaction.class);
    }

    @Override
    public Request<?, EthTransaction> ethGetTransactionByBlockHashAndIndex(String blockHash, BigInteger transactionIndex) {
        return new Request<String, EthTransaction>("eth_getTransactionByBlockHashAndIndex", Arrays.asList(blockHash, Numeric.encodeQuantity(transactionIndex)), this.web3jService, EthTransaction.class);
    }

    @Override
    public Request<?, EthTransaction> ethGetTransactionByBlockNumberAndIndex(DefaultBlockParameter defaultBlockParameter, BigInteger transactionIndex) {
        return new Request<String, EthTransaction>("eth_getTransactionByBlockNumberAndIndex", Arrays.asList(defaultBlockParameter.getValue(), Numeric.encodeQuantity(transactionIndex)), this.web3jService, EthTransaction.class);
    }

    @Override
    public Request<?, EthGetTransactionReceipt> ethGetTransactionReceipt(String transactionHash) {
        return new Request<String, EthGetTransactionReceipt>("eth_getTransactionReceipt", Arrays.asList(transactionHash), this.web3jService, EthGetTransactionReceipt.class);
    }

    @Override
    public Request<?, EthBlock> ethGetUncleByBlockHashAndIndex(String blockHash, BigInteger transactionIndex) {
        return new Request<String, EthBlock>("eth_getUncleByBlockHashAndIndex", Arrays.asList(blockHash, Numeric.encodeQuantity(transactionIndex)), this.web3jService, EthBlock.class);
    }

    @Override
    public Request<?, EthBlock> ethGetUncleByBlockNumberAndIndex(DefaultBlockParameter defaultBlockParameter, BigInteger uncleIndex) {
        return new Request<String, EthBlock>("eth_getUncleByBlockNumberAndIndex", Arrays.asList(defaultBlockParameter.getValue(), Numeric.encodeQuantity(uncleIndex)), this.web3jService, EthBlock.class);
    }

    @Override
    public Request<?, EthGetCompilers> ethGetCompilers() {
        return new Request("eth_getCompilers", Collections.emptyList(), this.web3jService, EthGetCompilers.class);
    }

    @Override
    public Request<?, EthCompileLLL> ethCompileLLL(String sourceCode) {
        return new Request<String, EthCompileLLL>("eth_compileLLL", Arrays.asList(sourceCode), this.web3jService, EthCompileLLL.class);
    }

    @Override
    public Request<?, EthCompileSolidity> ethCompileSolidity(String sourceCode) {
        return new Request<String, EthCompileSolidity>("eth_compileSolidity", Arrays.asList(sourceCode), this.web3jService, EthCompileSolidity.class);
    }

    @Override
    public Request<?, EthCompileSerpent> ethCompileSerpent(String sourceCode) {
        return new Request<String, EthCompileSerpent>("eth_compileSerpent", Arrays.asList(sourceCode), this.web3jService, EthCompileSerpent.class);
    }

    @Override
    public Request<?, org.web3j.protocol.core.methods.response.EthFilter> ethNewFilter(EthFilter ethFilter) {
        return new Request<EthFilter, org.web3j.protocol.core.methods.response.EthFilter>("eth_newFilter", Arrays.asList(ethFilter), this.web3jService, org.web3j.protocol.core.methods.response.EthFilter.class);
    }

    @Override
    public Request<?, org.web3j.protocol.core.methods.response.EthFilter> ethNewBlockFilter() {
        return new Request("eth_newBlockFilter", Collections.emptyList(), this.web3jService, org.web3j.protocol.core.methods.response.EthFilter.class);
    }

    @Override
    public Request<?, org.web3j.protocol.core.methods.response.EthFilter> ethNewPendingTransactionFilter() {
        return new Request("eth_newPendingTransactionFilter", Collections.emptyList(), this.web3jService, org.web3j.protocol.core.methods.response.EthFilter.class);
    }

    @Override
    public Request<?, EthUninstallFilter> ethUninstallFilter(BigInteger filterId) {
        return new Request<String, EthUninstallFilter>("eth_uninstallFilter", Arrays.asList(Numeric.toHexStringWithPrefixSafe(filterId)), this.web3jService, EthUninstallFilter.class);
    }

    @Override
    public Request<?, EthLog> ethGetFilterChanges(BigInteger filterId) {
        return new Request<String, EthLog>("eth_getFilterChanges", Arrays.asList(Numeric.toHexStringWithPrefixSafe(filterId)), this.web3jService, EthLog.class);
    }

    @Override
    public Request<?, EthLog> ethGetFilterLogs(BigInteger filterId) {
        return new Request<String, EthLog>("eth_getFilterLogs", Arrays.asList(Numeric.toHexStringWithPrefixSafe(filterId)), this.web3jService, EthLog.class);
    }

    @Override
    public Request<?, EthLog> ethGetLogs(EthFilter ethFilter) {
        return new Request<EthFilter, EthLog>("eth_getLogs", Arrays.asList(ethFilter), this.web3jService, EthLog.class);
    }

    @Override
    public Request<?, EthGetWork> ethGetWork() {
        return new Request("eth_getWork", Collections.emptyList(), this.web3jService, EthGetWork.class);
    }

    @Override
    public Request<?, EthSubmitWork> ethSubmitWork(String nonce, String headerPowHash, String mixDigest) {
        return new Request<String, EthSubmitWork>("eth_submitWork", Arrays.asList(nonce, headerPowHash, mixDigest), this.web3jService, EthSubmitWork.class);
    }

    @Override
    public Request<?, EthSubmitHashrate> ethSubmitHashrate(String hashrate, String clientId) {
        return new Request<String, EthSubmitHashrate>("eth_submitHashrate", Arrays.asList(hashrate, clientId), this.web3jService, EthSubmitHashrate.class);
    }

    @Override
    public Request<?, DbPutString> dbPutString(String databaseName, String keyName, String stringToStore) {
        return new Request<String, DbPutString>("db_putString", Arrays.asList(databaseName, keyName, stringToStore), this.web3jService, DbPutString.class);
    }

    @Override
    public Request<?, DbGetString> dbGetString(String databaseName, String keyName) {
        return new Request<String, DbGetString>("db_getString", Arrays.asList(databaseName, keyName), this.web3jService, DbGetString.class);
    }

    @Override
    public Request<?, DbPutHex> dbPutHex(String databaseName, String keyName, String dataToStore) {
        return new Request<String, DbPutHex>("db_putHex", Arrays.asList(databaseName, keyName, dataToStore), this.web3jService, DbPutHex.class);
    }

    @Override
    public Request<?, DbGetHex> dbGetHex(String databaseName, String keyName) {
        return new Request<String, DbGetHex>("db_getHex", Arrays.asList(databaseName, keyName), this.web3jService, DbGetHex.class);
    }

    @Override
    public Request<?, org.web3j.protocol.core.methods.response.ShhPost> shhPost(ShhPost shhPost) {
        return new Request<ShhPost, org.web3j.protocol.core.methods.response.ShhPost>("shh_post", Arrays.asList(shhPost), this.web3jService, org.web3j.protocol.core.methods.response.ShhPost.class);
    }

    @Override
    public Request<?, ShhVersion> shhVersion() {
        return new Request("shh_version", Collections.emptyList(), this.web3jService, ShhVersion.class);
    }

    @Override
    public Request<?, ShhNewIdentity> shhNewIdentity() {
        return new Request("shh_newIdentity", Collections.emptyList(), this.web3jService, ShhNewIdentity.class);
    }

    @Override
    public Request<?, ShhHasIdentity> shhHasIdentity(String identityAddress) {
        return new Request<String, ShhHasIdentity>("shh_hasIdentity", Arrays.asList(identityAddress), this.web3jService, ShhHasIdentity.class);
    }

    @Override
    public Request<?, ShhNewGroup> shhNewGroup() {
        return new Request("shh_newGroup", Collections.emptyList(), this.web3jService, ShhNewGroup.class);
    }

    @Override
    public Request<?, ShhAddToGroup> shhAddToGroup(String identityAddress) {
        return new Request<String, ShhAddToGroup>("shh_addToGroup", Arrays.asList(identityAddress), this.web3jService, ShhAddToGroup.class);
    }

    @Override
    public Request<?, ShhNewFilter> shhNewFilter(ShhFilter shhFilter) {
        return new Request<ShhFilter, ShhNewFilter>("shh_newFilter", Arrays.asList(shhFilter), this.web3jService, ShhNewFilter.class);
    }

    @Override
    public Request<?, ShhUninstallFilter> shhUninstallFilter(BigInteger filterId) {
        return new Request<String, ShhUninstallFilter>("shh_uninstallFilter", Arrays.asList(Numeric.toHexStringWithPrefixSafe(filterId)), this.web3jService, ShhUninstallFilter.class);
    }

    @Override
    public Request<?, ShhMessages> shhGetFilterChanges(BigInteger filterId) {
        return new Request<String, ShhMessages>("shh_getFilterChanges", Arrays.asList(Numeric.toHexStringWithPrefixSafe(filterId)), this.web3jService, ShhMessages.class);
    }

    @Override
    public Request<?, ShhMessages> shhGetMessages(BigInteger filterId) {
        return new Request<String, ShhMessages>("shh_getMessages", Arrays.asList(Numeric.toHexStringWithPrefixSafe(filterId)), this.web3jService, ShhMessages.class);
    }

    @Override
    public Flowable<NewHeadsNotification> newHeadsNotifications() {
        return this.web3jService.subscribe(new Request<String, EthSubscribe>("eth_subscribe", Collections.singletonList("newHeads"), this.web3jService, EthSubscribe.class), "eth_unsubscribe", NewHeadsNotification.class);
    }

    @Override
    public Flowable<LogNotification> logsNotifications(List<String> addresses, List<String> topics) {
        Map<String, Object> params = this.createLogsParams(addresses, topics);
        return this.web3jService.subscribe(new Request<Object, EthSubscribe>("eth_subscribe", Arrays.asList("logs", params), this.web3jService, EthSubscribe.class), "eth_unsubscribe", LogNotification.class);
    }

    private Map<String, Object> createLogsParams(List<String> addresses, List<String> topics) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!addresses.isEmpty()) {
            params.put("address", addresses);
        }
        if (!topics.isEmpty()) {
            params.put("topics", topics);
        }
        return params;
    }

    @Override
    public Flowable<String> ethBlockHashFlowable() {
        return this.web3jRx.ethBlockHashFlowable(this.blockTime);
    }

    @Override
    public Flowable<String> ethPendingTransactionHashFlowable() {
        return this.web3jRx.ethPendingTransactionHashFlowable(this.blockTime);
    }

    @Override
    public Flowable<Log> ethLogFlowable(EthFilter ethFilter) {
        return this.web3jRx.ethLogFlowable(ethFilter, this.blockTime);
    }

    @Override
    public Flowable<org.web3j.protocol.core.methods.response.Transaction> transactionFlowable() {
        return this.web3jRx.transactionFlowable(this.blockTime);
    }

    @Override
    public Flowable<org.web3j.protocol.core.methods.response.Transaction> pendingTransactionFlowable() {
        return this.web3jRx.pendingTransactionFlowable(this.blockTime);
    }

    @Override
    public Flowable<EthBlock> blockFlowable(boolean fullTransactionObjects) {
        return this.web3jRx.blockFlowable(fullTransactionObjects, this.blockTime);
    }

    @Override
    public Flowable<EthBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.web3jRx.replayBlocksFlowable(startBlock, endBlock, fullTransactionObjects);
    }

    @Override
    public Flowable<EthBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.web3jRx.replayBlocksFlowable(startBlock, endBlock, fullTransactionObjects, ascending);
    }

    @Override
    public Flowable<EthBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Flowable<EthBlock> onCompleteFlowable) {
        return this.web3jRx.replayPastBlocksFlowable(startBlock, fullTransactionObjects, onCompleteFlowable);
    }

    @Override
    public Flowable<EthBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.web3jRx.replayPastBlocksFlowable(startBlock, fullTransactionObjects);
    }

    @Override
    public Flowable<org.web3j.protocol.core.methods.response.Transaction> replayPastTransactionsFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        return this.web3jRx.replayTransactionsFlowable(startBlock, endBlock);
    }

    @Override
    public Flowable<org.web3j.protocol.core.methods.response.Transaction> replayPastTransactionsFlowable(DefaultBlockParameter startBlock) {
        return this.web3jRx.replayPastTransactionsFlowable(startBlock);
    }

    @Override
    public Flowable<EthBlock> replayPastAndFutureBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.web3jRx.replayPastAndFutureBlocksFlowable(startBlock, fullTransactionObjects, this.blockTime);
    }

    @Override
    public Flowable<org.web3j.protocol.core.methods.response.Transaction> replayPastAndFutureTransactionsFlowable(DefaultBlockParameter startBlock) {
        return this.web3jRx.replayPastAndFutureTransactionsFlowable(startBlock, this.blockTime);
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
        try {
            this.web3jService.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close web3j service", e);
        }
    }

    @Override
    public BatchRequest newBatch() {
        return new BatchRequest(this.web3jService);
    }
}

