/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum.enclave;

import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.quorum.PrivacyFlag;
import org.web3j.quorum.Quorum;
import org.web3j.quorum.enclave.Enclave;
import org.web3j.quorum.enclave.ReceiveResponse;
import org.web3j.quorum.enclave.SendResponse;
import org.web3j.quorum.enclave.StoreRawRequest;
import org.web3j.quorum.enclave.protocol.EnclaveService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0012H\u0016J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/web3j/quorum/enclave/Tessera;", "Lorg/web3j/quorum/enclave/Enclave;", "service", "Lorg/web3j/quorum/enclave/protocol/EnclaveService;", "web3", "Lorg/web3j/quorum/Quorum;", "(Lorg/web3j/quorum/enclave/protocol/EnclaveService;Lorg/web3j/quorum/Quorum;)V", "deleteRequest", "", "key", "", "receiveRequest", "Lorg/web3j/quorum/enclave/ReceiveResponse;", "to", "sendRawRequest", "Lorg/web3j/protocol/core/methods/response/EthSendTransaction;", "payload", "privateFor", "", "privacyFlag", "Lorg/web3j/quorum/PrivacyFlag;", "mandatoryFor", "storeRawRequest", "Lorg/web3j/quorum/enclave/SendResponse;", "from", "upCheck", "web3j-quorum"})
public final class Tessera
implements Enclave {
    @NotNull
    private final EnclaveService service;
    @NotNull
    private final Quorum web3;

    public Tessera(@NotNull EnclaveService service, @NotNull Quorum web3) {
        Intrinsics.checkNotNullParameter(service, "service");
        Intrinsics.checkNotNullParameter(web3, "web3");
        this.service = service;
        this.web3 = web3;
    }

    @Override
    @NotNull
    public EthSendTransaction sendRawRequest(@NotNull String payload, @NotNull List<String> privateFor, @Nullable PrivacyFlag privacyFlag, @Nullable List<String> mandatoryFor) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        Intrinsics.checkNotNullParameter(privateFor, "privateFor");
        EthSendTransaction ethSendTransaction = this.web3.ethSendRawPrivateTransaction(payload, privateFor, privacyFlag, mandatoryFor).send();
        Intrinsics.checkNotNullExpressionValue(ethSendTransaction, "web3.ethSendRawPrivateTr\u2026lag, mandatoryFor).send()");
        return ethSendTransaction;
    }

    @Override
    @NotNull
    public SendResponse storeRawRequest(@NotNull String payload, @NotNull String from, @NotNull List<String> to) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        StoreRawRequest storeRawRequest = new StoreRawRequest(payload, from);
        return this.service.send(storeRawRequest, "storeraw", SendResponse.class);
    }

    @Override
    @NotNull
    public ReceiveResponse receiveRequest(@NotNull String key, @NotNull String to) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(to, "to");
        throw new NotImplementedError("Tessera receive not supported");
    }

    @Override
    public boolean upCheck() {
        String test = this.service.send("upcheck");
        return Intrinsics.areEqual(test, "I'm up!");
    }

    @Override
    public boolean deleteRequest(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        throw new NotImplementedError("Tessera delete not implemented");
    }

    @Override
    @NotNull
    public EthSendTransaction sendRawRequest(@NotNull String payload, @NotNull List<String> privateFor) {
        return Enclave.DefaultImpls.sendRawRequest(this, payload, privateFor);
    }

    @Override
    @NotNull
    public EthSendTransaction sendRawRequest(@NotNull String payload, @NotNull List<String> privateFor, @NotNull PrivacyFlag privacyFlag) {
        return Enclave.DefaultImpls.sendRawRequest(this, payload, privateFor, privacyFlag);
    }
}

