/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.Hash;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.exceptions.TxHashMismatchException;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;
import org.web3j.utils.TxHashVerifier;

public class RawTransactionManager
extends TransactionManager {
    private final Web3j web3j;
    final Credentials credentials;
    private final long chainId;
    protected TxHashVerifier txHashVerifier = new TxHashVerifier();

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId) {
        super(web3j, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(transactionReceiptProcessor, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId, int attempts, long sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials) {
        this(web3j, credentials, -1L);
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, int attempts, int sleepDuration) {
        this(web3j, credentials, -1L, attempts, sleepDuration);
    }

    protected BigInteger getNonce() throws IOException {
        EthGetTransactionCount ethGetTransactionCount = this.web3j.ethGetTransactionCount(this.credentials.getAddress(), DefaultBlockParameterName.PENDING).send();
        return ethGetTransactionCount.getTransactionCount();
    }

    public TxHashVerifier getTxHashVerifier() {
        return this.txHashVerifier;
    }

    public void setTxHashVerifier(TxHashVerifier txHashVerifier) {
        this.txHashVerifier = txHashVerifier;
    }

    @Override
    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data2, BigInteger value, boolean constructor) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction(nonce, gasPrice, gasLimit, to, value, data2);
        return this.signAndSend(rawTransaction);
    }

    @Override
    public EthSendTransaction sendTransactionEIP1559(BigInteger gasPremium, BigInteger feeCap, BigInteger gasLimit, String to, String data2, BigInteger value, boolean constructor) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction(nonce, null, gasLimit, to, value, data2, gasPremium, feeCap);
        return this.signAndSend(rawTransaction);
    }

    @Override
    public String sendCall(String to, String data2, DefaultBlockParameter defaultBlockParameter) throws IOException {
        EthCall ethCall = this.web3j.ethCall(Transaction.createEthCallTransaction(this.getFromAddress(), to, data2), defaultBlockParameter).send();
        RawTransactionManager.assertCallNotReverted(ethCall);
        return ethCall.getValue();
    }

    @Override
    public EthGetCode getCode(String contractAddress, DefaultBlockParameter defaultBlockParameter) throws IOException {
        return this.web3j.ethGetCode(contractAddress, defaultBlockParameter).send();
    }

    public String sign(RawTransaction rawTransaction) {
        byte[] signedMessage = this.chainId > -1L ? TransactionEncoder.signMessage(rawTransaction, this.chainId, this.credentials) : TransactionEncoder.signMessage(rawTransaction, this.credentials);
        return Numeric.toHexString(signedMessage);
    }

    public EthSendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        String txHashRemote;
        String txHashLocal;
        String hexValue = this.sign(rawTransaction);
        EthSendTransaction ethSendTransaction = this.web3j.ethSendRawTransaction(hexValue).send();
        if (ethSendTransaction != null && !ethSendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3(hexValue), txHashRemote = ethSendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return ethSendTransaction;
    }
}

