/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.exceptions.ContractCallException;
import org.web3j.tx.response.PollingTransactionReceiptProcessor;
import org.web3j.tx.response.TransactionReceiptProcessor;

public abstract class TransactionManager {
    public static final int DEFAULT_POLLING_ATTEMPTS_PER_TX_HASH = 40;
    public static final long DEFAULT_POLLING_FREQUENCY = 15000L;
    public static final String REVERT_ERR_STR = "Contract Call has been reverted by the EVM with the reason: '%s'.";
    private final TransactionReceiptProcessor transactionReceiptProcessor;
    private final String fromAddress;

    protected TransactionManager(TransactionReceiptProcessor transactionReceiptProcessor, String fromAddress) {
        this.transactionReceiptProcessor = transactionReceiptProcessor;
        this.fromAddress = fromAddress;
    }

    protected TransactionManager(Web3j web3j, String fromAddress) {
        this(new PollingTransactionReceiptProcessor(web3j, 15000L, 40), fromAddress);
    }

    protected TransactionManager(Web3j web3j, int attempts, long sleepDuration, String fromAddress) {
        this(new PollingTransactionReceiptProcessor(web3j, sleepDuration, attempts), fromAddress);
    }

    protected TransactionReceipt executeTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data2, BigInteger value) throws IOException, TransactionException {
        return this.executeTransaction(gasPrice, gasLimit, to, data2, value, false);
    }

    protected TransactionReceipt executeTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data2, BigInteger value, boolean constructor) throws IOException, TransactionException {
        EthSendTransaction ethSendTransaction = this.sendTransaction(gasPrice, gasLimit, to, data2, value, constructor);
        return this.processResponse(ethSendTransaction);
    }

    protected TransactionReceipt executeTransactionEIP1559(BigInteger gasPremium, BigInteger feeCap, BigInteger gasLimit, String to, String data2, BigInteger value) throws IOException, TransactionException {
        return this.executeTransactionEIP1559(gasPremium, feeCap, gasLimit, to, data2, value, false);
    }

    protected TransactionReceipt executeTransactionEIP1559(BigInteger gasPremium, BigInteger feeCap, BigInteger gasLimit, String to, String data2, BigInteger value, boolean constructor) throws IOException, TransactionException {
        EthSendTransaction ethSendTransaction = this.sendTransactionEIP1559(gasPremium, feeCap, gasLimit, to, data2, value, constructor);
        return this.processResponse(ethSendTransaction);
    }

    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data2, BigInteger value) throws IOException {
        return this.sendTransaction(gasPrice, gasLimit, to, data2, value, false);
    }

    public EthSendTransaction sendTransactionEIP1559(BigInteger gasPremium, BigInteger feeCap, BigInteger gasLimit, String to, String data2, BigInteger value) throws IOException {
        return this.sendTransactionEIP1559(gasPremium, feeCap, gasLimit, to, data2, value, false);
    }

    public abstract EthSendTransaction sendTransaction(BigInteger var1, BigInteger var2, String var3, String var4, BigInteger var5, boolean var6) throws IOException;

    public abstract EthSendTransaction sendTransactionEIP1559(BigInteger var1, BigInteger var2, BigInteger var3, String var4, String var5, BigInteger var6, boolean var7) throws IOException;

    public abstract String sendCall(String var1, String var2, DefaultBlockParameter var3) throws IOException;

    public abstract EthGetCode getCode(String var1, DefaultBlockParameter var2) throws IOException;

    public String getFromAddress() {
        return this.fromAddress;
    }

    private TransactionReceipt processResponse(EthSendTransaction transactionResponse) throws IOException, TransactionException {
        if (transactionResponse.hasError()) {
            throw new RuntimeException("Error processing transaction request: " + transactionResponse.getError().getMessage());
        }
        String transactionHash = transactionResponse.getTransactionHash();
        return this.transactionReceiptProcessor.waitForTransactionReceipt(transactionHash);
    }

    static void assertCallNotReverted(EthCall ethCall) {
        if (ethCall.isReverted()) {
            throw new ContractCallException(String.format(REVERT_ERR_STR, ethCall.getRevertReason()));
        }
    }
}

