/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import org.apache.camel.CamelContext;
import org.apache.camel.component.webhook.WebhookComponent;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class WebhookComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private WebhookConfiguration getOrCreateConfiguration(WebhookComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new WebhookConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        WebhookComponent target = (WebhookComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(WebhookComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(WebhookComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(WebhookComponentConfigurer.property(camelContext, WebhookConfiguration.class, value));
                return true;
            }
            case "webhookautoregister": 
            case "webhookAutoRegister": {
                this.getOrCreateConfiguration(target).setWebhookAutoRegister(WebhookComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "webhookbasepath": 
            case "webhookBasePath": {
                this.getOrCreateConfiguration(target).setWebhookBasePath(WebhookComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "webhookcomponentname": 
            case "webhookComponentName": {
                this.getOrCreateConfiguration(target).setWebhookComponentName(WebhookComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "webhookexternalurl": 
            case "webhookExternalUrl": {
                this.getOrCreateConfiguration(target).setWebhookExternalUrl(WebhookComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "webhookpath": 
            case "webhookPath": {
                this.getOrCreateConfiguration(target).setWebhookPath(WebhookComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return WebhookConfiguration.class;
            }
            case "webhookautoregister": 
            case "webhookAutoRegister": {
                return Boolean.TYPE;
            }
            case "webhookbasepath": 
            case "webhookBasePath": {
                return String.class;
            }
            case "webhookcomponentname": 
            case "webhookComponentName": {
                return String.class;
            }
            case "webhookexternalurl": 
            case "webhookExternalUrl": {
                return String.class;
            }
            case "webhookpath": 
            case "webhookPath": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        WebhookComponent target = (WebhookComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "webhookautoregister": 
            case "webhookAutoRegister": {
                return this.getOrCreateConfiguration(target).isWebhookAutoRegister();
            }
            case "webhookbasepath": 
            case "webhookBasePath": {
                return this.getOrCreateConfiguration(target).getWebhookBasePath();
            }
            case "webhookcomponentname": 
            case "webhookComponentName": {
                return this.getOrCreateConfiguration(target).getWebhookComponentName();
            }
            case "webhookexternalurl": 
            case "webhookExternalUrl": {
                return this.getOrCreateConfiguration(target).getWebhookExternalUrl();
            }
            case "webhookpath": 
            case "webhookPath": {
                return this.getOrCreateConfiguration(target).getWebhookPath();
            }
        }
        return null;
    }
}

