/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api.auth;

import org.apache.camel.component.wordpress.api.auth.BaseWordpressAuthentication;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordpressBasicAuthentication
extends BaseWordpressAuthentication {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordpressBasicAuthentication.class);

    public WordpressBasicAuthentication() {
    }

    public WordpressBasicAuthentication(String username, String password) {
        super(username, password);
    }

    @Override
    public void configureAuthentication(Object api) {
        if (this.isCredentialsSet()) {
            String authorizationHeader = String.format("Basic %s", Base64Utility.encode(String.format("%s:%s", this.username, this.password).getBytes()));
            LOGGER.info("Credentials set for user {}", (Object)this.username);
            WebClient.client(api).header("Authorization", authorizationHeader);
        } else {
            LOGGER.warn("Credentials not set because username or password are empty.");
        }
    }
}

