/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday.producer;

import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.WorkdayEndpoint;
import org.apache.camel.component.workday.auth.AuthClientForIntegration;
import org.apache.camel.component.workday.auth.AuthenticationClient;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultProducer;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;

public abstract class WorkdayDefaultProducer
extends DefaultProducer {
    @Metadata(description="The workday URL", javaType="String")
    public static final String WORKDAY_URL_HEADER = "CamelWorkdayURL";
    private final WorkdayEndpoint endpoint;
    private final AuthenticationClient authenticationClient;

    public WorkdayDefaultProducer(WorkdayEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
        this.authenticationClient = new AuthClientForIntegration(this.endpoint.getWorkdayConfiguration());
    }

    @Override
    public WorkdayEndpoint getEndpoint() {
        return (WorkdayEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        PoolingHttpClientConnectionManager httpClientConnectionManager = this.endpoint.getWorkdayConfiguration().getHttpConnectionManager();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager(httpClientConnectionManager).build();
        String workdayUri = this.prepareUri(this.endpoint.getWorkdayConfiguration());
        HttpGet httpGet = new HttpGet(workdayUri);
        this.authenticationClient.configure(httpClient, httpGet);
        try {
            httpClient.execute((ClassicHttpRequest)httpGet, httpResponse -> {
                if (httpResponse.getCode() != 200) {
                    throw new IllegalStateException("Got the invalid http status value '" + String.valueOf(new StatusLine(httpResponse)) + "' as the result of the RAAS '" + workdayUri + "'");
                }
                try {
                    String report = this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, httpResponse.getEntity().getContent());
                    if (report.isEmpty()) {
                        throw new IllegalStateException("Got the unexpected value '" + report + "' as the result of the report '" + workdayUri + "'");
                    }
                    exchange.getIn().setBody(report);
                    exchange.getIn().setHeader(WORKDAY_URL_HEADER, workdayUri);
                    return null;
                }
                catch (NoTypeConversionAvailableException e) {
                    throw new RuntimeCamelException(e);
                }
            });
        }
        catch (RuntimeCamelException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception ex = (Exception)throwable;
                throw ex;
            }
            throw e;
        }
    }

    public abstract String prepareUri(WorkdayConfiguration var1) throws Exception;
}

