/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

abstract class BaseOrderedProperties
extends Properties {
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();

    BaseOrderedProperties() {
    }

    public Map<String, Object> asMap() {
        return this.map;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.doPut(key.toString(), value.toString());
    }

    protected Object doPut(String key, String value) {
        return this.map.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<?, ?> t2) {
        for (Map.Entry<?, ?> entry : t2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public String getProperty(String key) {
        return (String)this.map.get(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return (String)this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return new Vector<String>(this.map.keySet()).elements();
    }

    @Override
    public Set<Object> keySet() {
        return new LinkedHashSet<Object>(this.map.keySet());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return new ArrayList<Object>(this.map.values());
    }

    @Override
    public synchronized String toString() {
        return this.map.toString();
    }
}

