/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import org.knowm.xchange.binance.config.converter.StringToCurrencyPairConverter;
import org.knowm.xchange.currency.CurrencyPair;

@JsonDeserialize(builder=BinancePriceBuilder.class)
public class BinancePrice {
    @JsonProperty(value="symbol")
    @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
    CurrencyPair currencyPair;
    @JsonProperty(value="price")
    BigDecimal price;

    public boolean isValid() {
        return this.currencyPair != null && this.price != null;
    }

    BinancePrice(CurrencyPair currencyPair, BigDecimal price) {
        this.currencyPair = currencyPair;
        this.price = price;
    }

    public static BinancePriceBuilder builder() {
        return new BinancePriceBuilder();
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    @JsonProperty(value="symbol")
    @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
    public void setCurrencyPair(CurrencyPair currencyPair) {
        this.currencyPair = currencyPair;
    }

    @JsonProperty(value="price")
    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinancePrice)) {
            return false;
        }
        BinancePrice other = (BinancePrice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CurrencyPair this$currencyPair = this.getCurrencyPair();
        CurrencyPair other$currencyPair = other.getCurrencyPair();
        if (this$currencyPair == null ? other$currencyPair != null : !((Object)this$currencyPair).equals(other$currencyPair)) {
            return false;
        }
        BigDecimal this$price = this.getPrice();
        BigDecimal other$price = other.getPrice();
        return !(this$price == null ? other$price != null : !((Object)this$price).equals(other$price));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinancePrice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CurrencyPair $currencyPair = this.getCurrencyPair();
        result = result * 59 + ($currencyPair == null ? 43 : ((Object)$currencyPair).hashCode());
        BigDecimal $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        return result;
    }

    public String toString() {
        return "BinancePrice(currencyPair=" + this.getCurrencyPair() + ", price=" + this.getPrice() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class BinancePriceBuilder {
        private CurrencyPair currencyPair;
        private BigDecimal price;

        BinancePriceBuilder() {
        }

        @JsonProperty(value="symbol")
        @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
        public BinancePriceBuilder currencyPair(CurrencyPair currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        @JsonProperty(value="price")
        public BinancePriceBuilder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public BinancePrice build() {
            return new BinancePrice(this.currencyPair, this.price);
        }

        public String toString() {
            return "BinancePrice.BinancePriceBuilder(currencyPair=" + this.currencyPair + ", price=" + this.price + ")";
        }
    }
}

