/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.derivative.OptionsContract;
import org.knowm.xchange.instrument.Instrument;

public class InstrumentDeserializer
extends JsonDeserializer<Instrument> {
    public InstrumentDeserializer() {
        this(null);
    }

    public InstrumentDeserializer(Class<?> vc) {
    }

    @Override
    public Instrument deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        String instrumentString = node.asText();
        long count = instrumentString.chars().filter(ch -> ch == 47).count();
        if (count == 1L) {
            return new CurrencyPair(instrumentString);
        }
        if (count == 2L) {
            return new FuturesContract(instrumentString);
        }
        if (count == 4L) {
            return new OptionsContract(instrumentString);
        }
        return null;
    }
}

