/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xchange.XChange;
import org.apache.camel.component.xchange.XChangeAccountProducer;
import org.apache.camel.component.xchange.XChangeComponent;
import org.apache.camel.component.xchange.XChangeConfiguration;
import org.apache.camel.component.xchange.XChangeMarketDataProducer;
import org.apache.camel.component.xchange.XChangeMetaDataProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.service.BinanceAccountService;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.utils.Assert;

@UriEndpoint(firstVersion="2.21.0", scheme="xchange", title="XChange", syntax="xchange:name", producerOnly=true, category={Category.BLOCKCHAIN}, headersClass=XChangeConfiguration.class)
public class XChangeEndpoint
extends DefaultEndpoint {
    @UriParam
    private XChangeConfiguration configuration;
    private transient XChange xchange;

    public XChangeEndpoint(String uri, XChangeComponent component, XChangeConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    @Override
    public XChangeComponent getComponent() {
        return (XChangeComponent)super.getComponent();
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public Producer createProducer() throws Exception {
        DefaultProducer producer = null;
        XChangeConfiguration.XChangeService service = this.getConfiguration().getService();
        if (XChangeConfiguration.XChangeService.account == service) {
            producer = new XChangeAccountProducer(this);
        } else if (XChangeConfiguration.XChangeService.marketdata == service) {
            producer = new XChangeMarketDataProducer(this);
        } else if (XChangeConfiguration.XChangeService.metadata == service) {
            producer = new XChangeMetaDataProducer(this);
        }
        Assert.notNull(producer, "Unsupported service: " + String.valueOf((Object)service));
        return producer;
    }

    public void setConfiguration(XChangeConfiguration configuration) {
        this.configuration = configuration;
    }

    public XChangeConfiguration getConfiguration() {
        return this.configuration;
    }

    public XChange getXchange() {
        return this.xchange;
    }

    public void setXchange(XChange xchange) {
        this.xchange = xchange;
    }

    public List<Currency> getCurrencies() {
        ExchangeMetaData metaData = this.xchange.getExchangeMetaData();
        return metaData.getCurrencies().keySet().stream().sorted().collect(Collectors.toList());
    }

    public CurrencyMetaData getCurrencyMetaData(Currency curr) {
        Assert.notNull(curr, "Null currency");
        ExchangeMetaData metaData = this.xchange.getExchangeMetaData();
        return metaData.getCurrencies().get(curr);
    }

    public List<CurrencyPair> getCurrencyPairs() {
        ExchangeMetaData metaData = this.xchange.getExchangeMetaData();
        return metaData.getInstruments().keySet().stream().filter(it -> it instanceof CurrencyPair).map(it -> (CurrencyPair)it).sorted().collect(Collectors.toList());
    }

    public InstrumentMetaData getCurrencyPairMetaData(CurrencyPair pair) {
        Assert.notNull(pair, "Null currency");
        ExchangeMetaData metaData = this.xchange.getExchangeMetaData();
        return metaData.getInstruments().get(pair);
    }

    public List<Balance> getBalances() throws IOException {
        ArrayList balances = new ArrayList();
        this.getWallets().stream().forEach(w -> {
            for (Balance aux : w.getBalances().values()) {
                Currency curr = aux.getCurrency();
                CurrencyMetaData metaData = this.getCurrencyMetaData(curr);
                if (metaData == null) continue;
                int scale = metaData.getScale();
                double total = aux.getTotal().doubleValue();
                double scaledTotal = total * Math.pow(10.0, scale / 2);
                if (!(1.0 <= scaledTotal)) continue;
                balances.add(aux);
            }
        });
        return balances.stream().sorted((o1, o2) -> o1.getCurrency().compareTo(o2.getCurrency())).collect(Collectors.toList());
    }

    public List<FundingRecord> getFundingHistory() throws IOException {
        AccountService accountService = this.xchange.getAccountService();
        TradeHistoryParams fundingHistoryParams = accountService.createFundingHistoryParams();
        return accountService.getFundingHistory(fundingHistoryParams).stream().sorted((o1, o2) -> o1.getDate().compareTo(o2.getDate())).collect(Collectors.toList());
    }

    public List<Wallet> getWallets() throws IOException {
        AccountService accountService = this.xchange.getAccountService();
        if (accountService instanceof BinanceAccountService) {
            BinanceAccountService binanceAccountService = (BinanceAccountService)accountService;
            Wallet wallet = BinanceAdapters.adaptBinanceSpotWallet(binanceAccountService.account());
            return Collections.singletonList(wallet);
        }
        AccountInfo accountInfo = accountService.getAccountInfo();
        return accountInfo.getWallets().values().stream().sorted(Comparator.comparing(Wallet::getName)).collect(Collectors.toList());
    }

    public Ticker getTicker(CurrencyPair pair) throws IOException {
        Assert.notNull(pair, "Null currency pair");
        MarketDataService marketService = this.xchange.getMarketDataService();
        try {
            return marketService.getTicker((Instrument)pair, new Object[0]);
        }
        catch (NotYetImplementedForExchangeException notYetImplementedForExchangeException) {
            return marketService.getTicker(pair, new Object[0]);
        }
    }
}

