/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import org.apache.camel.CamelContext;
import org.apache.camel.component.xchange.XChangeConfiguration;
import org.apache.camel.component.xchange.XChangeEndpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.knowm.xchange.currency.Currency;

public class XChangeEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        XChangeEndpoint target = (XChangeEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "currency": {
                target.getConfiguration().setCurrency(XChangeEndpointConfigurer.property(camelContext, Currency.class, value));
                return true;
            }
            case "currencypair": 
            case "currencyPair": {
                target.getConfiguration().setCurrencyPair(XChangeEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(XChangeEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "method": {
                target.getConfiguration().setMethod(XChangeEndpointConfigurer.property(camelContext, XChangeConfiguration.XChangeMethod.class, value));
                return true;
            }
            case "service": {
                target.getConfiguration().setService(XChangeEndpointConfigurer.property(camelContext, XChangeConfiguration.XChangeService.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "currency": {
                return Currency.class;
            }
            case "currencypair": 
            case "currencyPair": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "method": {
                return XChangeConfiguration.XChangeMethod.class;
            }
            case "service": {
                return XChangeConfiguration.XChangeService.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        XChangeEndpoint target = (XChangeEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "currency": {
                return target.getConfiguration().getCurrency();
            }
            case "currencypair": 
            case "currencyPair": {
                return target.getConfiguration().getCurrencyPair();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "method": {
                return target.getConfiguration().getMethod();
            }
            case "service": {
                return target.getConfiguration().getService();
            }
        }
        return null;
    }
}

