/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeClassUtils;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExchangeFactory {
    INSTANCE;

    private final Logger log = LoggerFactory.getLogger(ExchangeFactory.class);

    public Exchange createExchange(String exchangeClassName) {
        return this.createExchange(exchangeClassName, null, null);
    }

    public <T extends Exchange> T createExchange(Class<T> exchangeClass) {
        return this.createExchange(exchangeClass, null, null);
    }

    public Exchange createExchange(String exchangeClassName, String apiKey, String secretKey) {
        Assert.notNull(exchangeClassName, "exchangeClassName cannot be null");
        this.log.debug("Creating default exchange from class name");
        Exchange exchange = this.createExchangeWithoutSpecification(exchangeClassName);
        ExchangeSpecification defaultExchangeSpecification = exchange.getDefaultExchangeSpecification();
        if (apiKey != null) {
            defaultExchangeSpecification.setApiKey(apiKey);
        }
        if (secretKey != null) {
            defaultExchangeSpecification.setSecretKey(secretKey);
        }
        exchange.applySpecification(defaultExchangeSpecification);
        return exchange;
    }

    public <T extends Exchange> T createExchange(Class<T> exchangeClass, String apiKey, String secretKey) {
        Assert.notNull(exchangeClass, "exchange cannot be null");
        this.log.debug("Creating default exchange from class name");
        T exchange = this.createExchangeWithoutSpecification(exchangeClass);
        ExchangeSpecification defaultExchangeSpecification = exchange.getDefaultExchangeSpecification();
        if (apiKey != null) {
            defaultExchangeSpecification.setApiKey(apiKey);
        }
        if (secretKey != null) {
            defaultExchangeSpecification.setSecretKey(secretKey);
        }
        exchange.applySpecification(defaultExchangeSpecification);
        return exchange;
    }

    public Exchange createExchange(ExchangeSpecification exchangeSpecification) {
        Assert.notNull(exchangeSpecification, "exchangeSpecfication cannot be null");
        this.log.debug("Creating exchange from specification");
        Class<? extends Exchange> exchangeClass = exchangeSpecification.getExchangeClass();
        Exchange exchange = this.createExchangeWithoutSpecification(exchangeClass);
        exchange.applySpecification(exchangeSpecification);
        return exchange;
    }

    public Exchange createExchangeWithoutSpecification(String exchangeClassName) {
        Assert.notNull(exchangeClassName, "exchangeClassName cannot be null");
        this.log.debug("Creating default exchange from class name");
        return this.createExchangeWithoutSpecification(ExchangeClassUtils.exchangeClassForName(exchangeClassName));
    }

    public <T extends Exchange> T createExchangeWithoutSpecification(Class<T> exchangeClass) {
        Assert.notNull(exchangeClass, "exchangeClassName cannot be null");
        this.log.debug("Creating default exchange from class name");
        try {
            return (T)((Exchange)exchangeClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new ExchangeException("Problem creating Exchange (instantiation)", e);
        }
        catch (IllegalAccessException e) {
            throw new ExchangeException("Problem creating Exchange (illegal access)", e);
        }
    }
}

