/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.meta;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.meta.FeeTier;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InstrumentMetaData
implements Serializable {
    private final BigDecimal tradingFee;
    private final FeeTier[] feeTiers;
    private final BigDecimal minimumAmount;
    private final BigDecimal maximumAmount;
    private final BigDecimal counterMinimumAmount;
    private final BigDecimal counterMaximumAmount;
    private final Integer priceScale;
    private final Integer volumeScale;
    private final BigDecimal amountStepSize;
    private final BigDecimal priceStepSize;
    private final Currency tradingFeeCurrency;
    private final boolean marketOrderEnabled;
    private final BigDecimal contractValue;

    public InstrumentMetaData(@JsonProperty(value="trading_fee") BigDecimal tradingFee, @JsonProperty(value="fee_tiers") FeeTier[] feeTiers, @JsonProperty(value="min_amount") BigDecimal minimumAmount, @JsonProperty(value="max_amount") BigDecimal maximumAmount, @JsonProperty(value="counter_min_amount") BigDecimal counterMinimumAmount, @JsonProperty(value="counter_max_amount") BigDecimal counterMaximumAmount, @JsonProperty(value="price_scale") Integer priceScale, @JsonProperty(value="volume_scale") Integer volumeScale, @JsonProperty(value="amount_step_size") BigDecimal amountStepSize, @JsonProperty(value="price_step_size") BigDecimal priceStepSize, @JsonProperty(value="trading_fee_currency") Currency tradingFeeCurrency, @JsonProperty(value="market_order_enabled") boolean marketOrderEnabled, @JsonProperty(value="contract_value") BigDecimal contractValue) {
        this.tradingFee = tradingFee;
        if (feeTiers != null) {
            Arrays.sort(feeTiers);
        }
        this.feeTiers = feeTiers;
        this.minimumAmount = minimumAmount != null ? minimumAmount.stripTrailingZeros() : null;
        this.maximumAmount = maximumAmount != null ? maximumAmount.stripTrailingZeros() : null;
        this.counterMinimumAmount = counterMinimumAmount != null ? counterMinimumAmount.stripTrailingZeros() : null;
        this.counterMaximumAmount = counterMaximumAmount != null ? counterMaximumAmount.stripTrailingZeros() : null;
        this.priceScale = priceScale;
        this.volumeScale = volumeScale;
        this.amountStepSize = amountStepSize != null ? amountStepSize.stripTrailingZeros() : null;
        this.priceStepSize = priceStepSize != null ? priceStepSize.stripTrailingZeros() : null;
        this.tradingFeeCurrency = tradingFeeCurrency;
        this.marketOrderEnabled = marketOrderEnabled;
        this.contractValue = contractValue;
    }

    public BigDecimal getTradingFee() {
        return this.tradingFee;
    }

    public FeeTier[] getFeeTiers() {
        return this.feeTiers;
    }

    public BigDecimal getMinimumAmount() {
        return this.minimumAmount;
    }

    public BigDecimal getMaximumAmount() {
        return this.maximumAmount;
    }

    public BigDecimal getCounterMinimumAmount() {
        return this.counterMinimumAmount;
    }

    public BigDecimal getCounterMaximumAmount() {
        return this.counterMaximumAmount;
    }

    public Integer getPriceScale() {
        return this.priceScale;
    }

    public Integer getVolumeScale() {
        return this.volumeScale;
    }

    public BigDecimal getAmountStepSize() {
        return this.amountStepSize;
    }

    public BigDecimal getPriceStepSize() {
        return this.priceStepSize;
    }

    public Currency getTradingFeeCurrency() {
        return this.tradingFeeCurrency;
    }

    public boolean isMarketOrderEnabled() {
        return this.marketOrderEnabled;
    }

    public BigDecimal getContractValue() {
        return this.contractValue;
    }

    public String toString() {
        return "InstrumentMetaData(tradingFee=" + this.getTradingFee() + ", feeTiers=" + Arrays.deepToString(this.getFeeTiers()) + ", minimumAmount=" + this.getMinimumAmount() + ", maximumAmount=" + this.getMaximumAmount() + ", counterMinimumAmount=" + this.getCounterMinimumAmount() + ", counterMaximumAmount=" + this.getCounterMaximumAmount() + ", priceScale=" + this.getPriceScale() + ", volumeScale=" + this.getVolumeScale() + ", amountStepSize=" + this.getAmountStepSize() + ", priceStepSize=" + this.getPriceStepSize() + ", tradingFeeCurrency=" + this.getTradingFeeCurrency() + ", marketOrderEnabled=" + this.isMarketOrderEnabled() + ", contractValue=" + this.getContractValue() + ")";
    }

    public static class Builder {
        private BigDecimal tradingFee;
        private FeeTier[] feeTiers;
        private BigDecimal minimumAmount;
        private BigDecimal maximumAmount;
        private BigDecimal counterMinimumAmount;
        private BigDecimal counterMaximumAmount;
        private Integer priceScale;
        private Integer volumeScale;
        private BigDecimal amountStepSize;
        private BigDecimal priceStepSize;
        private Currency tradingFeeCurrency;
        private boolean marketOrderEnabled;
        private BigDecimal contractValue;

        public Builder tradingFee(BigDecimal tradingFee) {
            this.tradingFee = tradingFee;
            return this;
        }

        public Builder feeTiers(FeeTier[] feeTiers) {
            this.feeTiers = feeTiers;
            return this;
        }

        public Builder minimumAmount(BigDecimal minimumAmount) {
            this.minimumAmount = minimumAmount != null ? minimumAmount.stripTrailingZeros() : null;
            return this;
        }

        public Builder maximumAmount(BigDecimal maximumAmount) {
            this.maximumAmount = maximumAmount != null ? maximumAmount.stripTrailingZeros() : null;
            return this;
        }

        public Builder counterMinimumAmount(BigDecimal counterMinimumAmount) {
            this.counterMinimumAmount = counterMinimumAmount != null ? counterMinimumAmount.stripTrailingZeros() : null;
            return this;
        }

        public Builder counterMaximumAmount(BigDecimal counterMaximumAmount) {
            this.counterMaximumAmount = counterMaximumAmount != null ? counterMaximumAmount.stripTrailingZeros() : null;
            return this;
        }

        public Builder priceScale(Integer priceScale) {
            this.priceScale = priceScale;
            return this;
        }

        public Builder volumeScale(Integer volumeScale) {
            this.volumeScale = volumeScale;
            return this;
        }

        public Builder amountStepSize(BigDecimal amountStepSize) {
            this.amountStepSize = amountStepSize != null ? amountStepSize.stripTrailingZeros() : null;
            return this;
        }

        public Builder priceStepSize(BigDecimal priceStepSize) {
            this.priceStepSize = priceStepSize != null ? priceStepSize.stripTrailingZeros() : null;
            return this;
        }

        public Builder tradingFeeCurrency(Currency tradingFeeCurrency) {
            this.tradingFeeCurrency = tradingFeeCurrency;
            return this;
        }

        public Builder marketOrderEnabled(boolean marketOrderEnabled) {
            this.marketOrderEnabled = marketOrderEnabled;
            return this;
        }

        public Builder contractValue(BigDecimal contractValue) {
            this.contractValue = contractValue;
            return this;
        }

        public InstrumentMetaData build() {
            return new InstrumentMetaData(this.tradingFee, this.feeTiers, this.minimumAmount, this.maximumAmount, this.counterMinimumAmount, this.counterMaximumAmount, this.priceScale, this.volumeScale, this.amountStepSize, this.priceStepSize, this.tradingFeeCurrency, this.marketOrderEnabled, this.contractValue);
        }
    }
}

