/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.instrument.Instrument;

public class BinanceFundingRate {
    private final Instrument instrument;
    private final BigDecimal markPrice;
    private final BigDecimal indexPrice;
    private final BigDecimal estimatedSettlePrice;
    private final BigDecimal lastFundingRate;
    private final Date nextFundingTime;
    private final BigDecimal interestRate;
    private final Date time;

    public BinanceFundingRate(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="markPrice") BigDecimal markPrice, @JsonProperty(value="indexPrice") BigDecimal indexPrice, @JsonProperty(value="estimatedSettlePrice") BigDecimal estimatedSettlePrice, @JsonProperty(value="lastFundingRate") BigDecimal lastFundingRate, @JsonProperty(value="nextFundingTime") Date nextFundingTime, @JsonProperty(value="interestRate") BigDecimal interestRate, @JsonProperty(value="time") Date time) {
        this.instrument = BinanceAdapters.adaptSymbol(symbol, true);
        this.markPrice = markPrice;
        this.indexPrice = indexPrice;
        this.estimatedSettlePrice = estimatedSettlePrice;
        this.lastFundingRate = lastFundingRate;
        this.nextFundingTime = nextFundingTime;
        this.interestRate = interestRate;
        this.time = time;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public BigDecimal getMarkPrice() {
        return this.markPrice;
    }

    public BigDecimal getIndexPrice() {
        return this.indexPrice;
    }

    public BigDecimal getEstimatedSettlePrice() {
        return this.estimatedSettlePrice;
    }

    public BigDecimal getLastFundingRate() {
        return this.lastFundingRate;
    }

    public Date getNextFundingTime() {
        return this.nextFundingTime;
    }

    public BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public Date getTime() {
        return this.time;
    }

    public String toString() {
        return "BinanceFundingRate(instrument=" + this.getInstrument() + ", markPrice=" + this.getMarkPrice() + ", indexPrice=" + this.getIndexPrice() + ", estimatedSettlePrice=" + this.getEstimatedSettlePrice() + ", lastFundingRate=" + this.getLastFundingRate() + ", nextFundingTime=" + this.getNextFundingTime() + ", interestRate=" + this.getInterestRate() + ", time=" + this.getTime() + ")";
    }
}

