/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.account;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.Balance;

public final class Wallet
implements Serializable {
    private static final long serialVersionUID = -4136681413143690633L;
    private final Map<Currency, Balance> balances;
    private final Collection<Balance> balanceCollection;
    private final String id;
    private final String name;
    private final Set<WalletFeature> features;
    private final BigDecimal maxLeverage;
    private final BigDecimal currentLeverage;

    public Wallet(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="balances") Collection<Balance> balances, @JsonProperty(value="features") Set<WalletFeature> features, @JsonProperty(value="maxLeverage") BigDecimal maxLeverage, @JsonProperty(value="currentLeverage") BigDecimal currentLeverage) {
        this.id = id;
        this.name = name == null ? id : name;
        this.balanceCollection = balances;
        if (balances.size() == 0) {
            this.balances = Collections.emptyMap();
        } else if (balances.size() == 1) {
            Balance balance = balances.iterator().next();
            this.balances = Collections.singletonMap(balance.getCurrency(), balance);
        } else {
            this.balances = new HashMap<Currency, Balance>();
            for (Balance balance : balances) {
                if (this.balances.containsKey(balance.getCurrency())) {
                    throw new IllegalArgumentException("duplicate balances in wallet");
                }
                this.balances.put(balance.getCurrency(), balance);
            }
        }
        this.features = features;
        this.maxLeverage = maxLeverage;
        this.currentLeverage = currentLeverage;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @JsonGetter
    public Collection<Balance> balances() {
        return this.balanceCollection;
    }

    @JsonIgnore
    public Map<Currency, Balance> getBalances() {
        return Collections.unmodifiableMap(this.balances);
    }

    public Set<WalletFeature> getFeatures() {
        return this.features;
    }

    public BigDecimal getMaxLeverage() {
        return this.maxLeverage;
    }

    public BigDecimal getCurrentLeverage() {
        return this.currentLeverage;
    }

    public Balance getBalance(Currency currency) {
        Balance balance = this.balances.get(currency);
        return balance == null ? Balance.zero(currency) : balance;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Wallet)) {
            return false;
        }
        Wallet wallet = (Wallet)object;
        return Objects.equals(this.id, wallet.id) && Objects.equals(this.name, wallet.name) && this.balances.equals(wallet.balances);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.balances);
    }

    public String toString() {
        return "Wallet{balances=" + this.balanceCollection + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", walletFeatures=" + this.features + ", maxLeverage=" + this.maxLeverage + ", currentLeverage=" + this.currentLeverage + '}';
    }

    public static class Builder {
        private Collection<Balance> balances;
        private String id;
        private String name;
        private Set<WalletFeature> features = Stream.of(WalletFeature.TRADING, WalletFeature.FUNDING).collect(Collectors.toSet());
        private BigDecimal maxLeverage = BigDecimal.ZERO;
        private BigDecimal currentLeverage = BigDecimal.ZERO;

        public static Builder from(Collection<Balance> balances) {
            return new Builder().balances(balances);
        }

        public Builder balances(Collection<Balance> balances) {
            this.balances = balances;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder features(Set<WalletFeature> features) {
            this.features = features;
            return this;
        }

        public Builder maxLeverage(BigDecimal maxLeverage) {
            this.maxLeverage = maxLeverage;
            return this;
        }

        public Builder currentLeverage(BigDecimal currentLeverage) {
            this.currentLeverage = currentLeverage;
            return this;
        }

        public Wallet build() {
            return new Wallet(this.id, this.name, this.balances, this.features, this.maxLeverage, this.currentLeverage);
        }
    }

    public static enum WalletFeature {
        FUNDING,
        TRADING,
        MARGIN_TRADING,
        MARGIN_FUNDING,
        FUTURES_TRADING;

    }
}

