/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.instrument.Instrument;

@JsonDeserialize(builder=Builder.class)
public class MarketOrder
extends Order {
    private static final long serialVersionUID = -3393286268772319210L;

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, Order.OrderStatus status, String userReference) {
        super(type, originalAmount, instrument, id, timestamp, averagePrice, cumulativeAmount, fee, status, userReference);
    }

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, Order.OrderStatus status) {
        super(type, originalAmount, instrument, id, timestamp, averagePrice, cumulativeAmount, fee, status);
    }

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp) {
        super(type, originalAmount, instrument, id, timestamp);
    }

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, Date timestamp) {
        super(type, originalAmount, instrument, "", timestamp);
    }

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument) {
        super(type, originalAmount, instrument, "", null);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends Order.Builder {
        @JsonCreator
        public Builder(@JsonProperty(value="orderType") Order.OrderType orderType, @JsonProperty(value="instrument") Instrument instrument) {
            super(orderType, instrument);
        }

        public static Builder from(Order order) {
            return ((Builder)new Builder(order.getType(), order.getInstrument()).originalAmount(order.getOriginalAmount()).cumulativeAmount(order.getCumulativeAmount()).timestamp(order.getTimestamp()).id(order.getId()).flags((Set)order.getOrderFlags())).averagePrice(order.getAveragePrice()).fee(order.getFee()).userReference(order.getUserReference()).orderStatus(order.getStatus());
        }

        @Override
        public Builder orderType(Order.OrderType orderType) {
            return (Builder)super.orderType(orderType);
        }

        @Override
        public Builder orderStatus(Order.OrderStatus status) {
            return (Builder)super.orderStatus(status);
        }

        @Override
        public Builder averagePrice(BigDecimal averagePrice) {
            return (Builder)super.averagePrice(averagePrice);
        }

        @Override
        public Builder cumulativeAmount(BigDecimal cumulativeAmount) {
            return (Builder)super.cumulativeAmount(cumulativeAmount);
        }

        @Override
        public Builder fee(BigDecimal fee) {
            return (Builder)super.fee(fee);
        }

        @Override
        public Builder originalAmount(BigDecimal originalAmount) {
            return (Builder)super.originalAmount(originalAmount);
        }

        @Override
        @Deprecated
        public Builder currencyPair(CurrencyPair currencyPair) {
            return (Builder)super.currencyPair(currencyPair);
        }

        @Override
        public Builder instrument(Instrument instrument) {
            return (Builder)super.instrument(instrument);
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder userReference(String userReference) {
            return (Builder)super.userReference(userReference);
        }

        @Override
        public Builder timestamp(Date timestamp) {
            return (Builder)super.timestamp(timestamp);
        }

        @Override
        public Builder flags(Set<Order.IOrderFlags> flags) {
            return (Builder)super.flags(flags);
        }

        @Override
        public Builder flag(Order.IOrderFlags flag) {
            return (Builder)super.flag(flag);
        }

        @Override
        public MarketOrder build() {
            MarketOrder order = new MarketOrder(this.orderType, this.originalAmount, this.instrument, this.id, this.timestamp, this.averagePrice, this.cumulativeAmount, this.fee, this.status, this.userReference);
            order.setOrderFlags(this.flags);
            order.setLeverage(this.leverage);
            return order;
        }
    }
}

