/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.service;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.retry.Retry;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.client.ResilienceUtils;
import org.knowm.xchange.service.BaseExchangeService;

public abstract class BaseResilientExchangeService<E extends Exchange>
extends BaseExchangeService<E> {
    protected final ResilienceRegistries resilienceRegistries;

    protected BaseResilientExchangeService(E exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange);
        this.resilienceRegistries = resilienceRegistries;
    }

    public <R> ResilienceUtils.DecorateCallableApi<R> decorateApiCall(ResilienceUtils.CallableApi<R> callable) {
        return ResilienceUtils.decorateApiCall(this.exchange.getExchangeSpecification().getResilience(), callable);
    }

    protected Retry retry(String name) {
        return this.resilienceRegistries.retries().retry(name);
    }

    protected Retry retry(String name, String configName) {
        return this.resilienceRegistries.retries().retry(name, configName);
    }

    protected RateLimiter rateLimiter(String name) {
        return this.resilienceRegistries.rateLimiters().rateLimiter(name);
    }

    protected RateLimiter rateLimiter(String name, String configName) {
        return this.resilienceRegistries.rateLimiters().rateLimiter(name, configName);
    }
}

