/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.trade.TradeService;
import si.mazi.rescu.SynchronizedValueFactory;

public class XChange
implements Exchange {
    private final Exchange delegate;

    public XChange(Exchange delegate) {
        this.delegate = delegate;
    }

    @Override
    public ExchangeSpecification getExchangeSpecification() {
        return this.delegate.getExchangeSpecification();
    }

    @Override
    public ExchangeMetaData getExchangeMetaData() {
        return this.delegate.getExchangeMetaData();
    }

    @Override
    public List<Instrument> getExchangeInstruments() {
        return this.delegate.getExchangeInstruments();
    }

    public List<CurrencyPair> getCurrencyPairs() {
        return this.delegate.getExchangeInstruments().stream().filter(it -> it instanceof CurrencyPair).map(it -> (CurrencyPair)it).collect(Collectors.toList());
    }

    @Override
    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.delegate.getNonceFactory();
    }

    @Override
    public ExchangeSpecification getDefaultExchangeSpecification() {
        return this.delegate.getDefaultExchangeSpecification();
    }

    @Override
    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        this.delegate.applySpecification(exchangeSpecification);
    }

    @Override
    public MarketDataService getMarketDataService() {
        return this.delegate.getMarketDataService();
    }

    @Override
    public TradeService getTradeService() {
        return this.delegate.getTradeService();
    }

    @Override
    public AccountService getAccountService() {
        return this.delegate.getAccountService();
    }

    @Override
    public void remoteInit() throws IOException, ExchangeException {
        this.delegate.remoteInit();
    }
}

