/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.xchange.XChangeConfiguration;
import org.apache.camel.component.xchange.XChangeEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;

public class XChangeAccountProducer
extends DefaultProducer {
    public XChangeAccountProducer(XChangeEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public XChangeEndpoint getEndpoint() {
        return (XChangeEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        XChangeEndpoint endpoint = this.getEndpoint();
        XChangeConfiguration.XChangeMethod method = endpoint.getConfiguration().getMethod();
        if (XChangeConfiguration.XChangeMethod.balances == method) {
            List<Balance> body = endpoint.getBalances();
            exchange.getMessage().setBody(body);
        } else if (XChangeConfiguration.XChangeMethod.fundingHistory == method) {
            List<FundingRecord> body = endpoint.getFundingHistory();
            exchange.getMessage().setBody(body);
        } else if (XChangeConfiguration.XChangeMethod.wallets == method) {
            List<Wallet> body = endpoint.getWallets();
            exchange.getMessage().setBody(body);
        }
    }
}

