/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.exceptions.ExchangeException;

public final class ExchangeClassUtils {
    private ExchangeClassUtils() {
    }

    public static Class<? extends Exchange> exchangeClassForName(String exchangeClassName) {
        try {
            Class<?> exchangeProviderClass = Class.forName(exchangeClassName);
            if (Exchange.class.isAssignableFrom(exchangeProviderClass)) {
                return exchangeProviderClass;
            }
            throw new ExchangeException("Class '" + exchangeClassName + "' does not implement Exchange");
        }
        catch (ClassNotFoundException e) {
            throw new ExchangeException("Problem creating Exchange (class not found)", e);
        }
    }
}

