/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.SimpleDateFormat;
import org.knowm.xchange.binance.dto.marketdata.KlineInterval;
import org.knowm.xchange.instrument.Instrument;

public final class BinanceKline {
    private final Instrument instrument;
    private final KlineInterval interval;
    private final long openTime;
    private final BigDecimal open;
    private final BigDecimal high;
    private final BigDecimal low;
    private final BigDecimal close;
    private final BigDecimal volume;
    private final long closeTime;
    private final BigDecimal quoteAssetVolume;
    private final long numberOfTrades;
    private final BigDecimal takerBuyBaseAssetVolume;
    private final BigDecimal takerBuyQuoteAssetVolume;
    private final boolean closed;

    public BinanceKline(Instrument instrument, KlineInterval interval, Object[] obj) {
        this.instrument = instrument;
        this.interval = interval;
        this.openTime = Long.parseLong(obj[0].toString());
        this.open = new BigDecimal(obj[1].toString());
        this.high = new BigDecimal(obj[2].toString());
        this.low = new BigDecimal(obj[3].toString());
        this.close = new BigDecimal(obj[4].toString());
        this.volume = new BigDecimal(obj[5].toString());
        this.closeTime = Long.parseLong(obj[6].toString());
        this.quoteAssetVolume = new BigDecimal(obj[7].toString());
        this.numberOfTrades = Long.parseLong(obj[8].toString());
        this.takerBuyBaseAssetVolume = new BigDecimal(obj[9].toString());
        this.takerBuyQuoteAssetVolume = new BigDecimal(obj[10].toString());
        this.closed = Boolean.parseBoolean(obj[11].toString());
    }

    public BigDecimal getAveragePrice() {
        return this.low.add(this.high).divide(new BigDecimal("2"), MathContext.DECIMAL32);
    }

    public String toString() {
        String tstamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.openTime);
        return String.format("[%s] %s %s O:%.6f A:%.6f C:%.6f", new Object[]{this.instrument, tstamp, this.interval, this.open, this.getAveragePrice(), this.close});
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public KlineInterval getInterval() {
        return this.interval;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public BigDecimal getOpen() {
        return this.open;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getClose() {
        return this.close;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public BigDecimal getQuoteAssetVolume() {
        return this.quoteAssetVolume;
    }

    public long getNumberOfTrades() {
        return this.numberOfTrades;
    }

    public BigDecimal getTakerBuyBaseAssetVolume() {
        return this.takerBuyBaseAssetVolume;
    }

    public BigDecimal getTakerBuyQuoteAssetVolume() {
        return this.takerBuyQuoteAssetVolume;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

