/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.binance.BinanceAuthenticated;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.BinanceFuturesAuthenticated;
import org.knowm.xchange.binance.dto.ExchangeType;
import org.knowm.xchange.binance.dto.meta.BinanceSystemStatus;
import org.knowm.xchange.binance.service.BinanceHmacDigest;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.service.BaseResilientExchangeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BinanceBaseService
extends BaseResilientExchangeService<BinanceExchange> {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected final String apiKey;
    protected final BinanceAuthenticated binance;
    protected BinanceFuturesAuthenticated binanceFutures;
    protected BinanceFuturesAuthenticated inverseBinanceFutures;
    protected final ParamsDigest signatureCreator;

    protected BinanceBaseService(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
        this.binance = ExchangeRestProxyBuilder.forInterface(BinanceAuthenticated.class, exchange.getExchangeSpecification()).build();
        if (exchange.getExchangeSpecification().getExchangeSpecificParametersItem(BinanceExchange.EXCHANGE_TYPE) != null) {
            switch ((ExchangeType)((Object)exchange.getExchangeSpecification().getExchangeSpecificParametersItem(BinanceExchange.EXCHANGE_TYPE))) {
                case SPOT: {
                    break;
                }
                case FUTURES: {
                    ExchangeSpecification futuresSpec = exchange.getExchangeSpecification();
                    this.binanceFutures = ExchangeRestProxyBuilder.forInterface(BinanceFuturesAuthenticated.class, futuresSpec).build();
                    this.inverseBinanceFutures = null;
                    break;
                }
                case INVERSE: {
                    ExchangeSpecification inverseFuturesSpec = exchange.getExchangeSpecification();
                    this.inverseBinanceFutures = ExchangeRestProxyBuilder.forInterface(BinanceFuturesAuthenticated.class, inverseFuturesSpec).build();
                    this.binanceFutures = null;
                }
            }
        }
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = BinanceHmacDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public Long getRecvWindow() {
        Object obj = ((BinanceExchange)this.exchange).getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            long value = ((Number)obj).longValue();
            if (value < 0L || value > 60000L) {
                throw new IllegalArgumentException("Exchange-specific parameter \"recvWindow\" must be in the range [0, 60000].");
            }
            return value;
        }
        if (obj.getClass().equals(String.class)) {
            try {
                return Long.parseLong((String)obj, 10);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Exchange-specific parameter \"recvWindow\" could not be parsed.", e);
            }
        }
        throw new IllegalArgumentException("Exchange-specific parameter \"recvWindow\" could not be parsed.");
    }

    public SynchronizedValueFactory<Long> getTimestampFactory() {
        return ((BinanceExchange)this.exchange).getTimestampFactory();
    }

    public BinanceSystemStatus getSystemStatus() throws IOException {
        return this.decorateApiCall(this.binance::systemStatus).call();
    }
}

