/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.client;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.retry.Retry;
import io.vavr.control.Either;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.knowm.xchange.ExchangeSpecification;
import si.mazi.rescu.HttpStatusExceptionSupport;

public final class ResilienceUtils {
    private ResilienceUtils() {
    }

    public static <T> DecorateCallableApi<T> decorateApiCall(ExchangeSpecification.ResilienceSpecification resilienceSpecification, CallableApi<T> callable) {
        return new DecorateCallableApi(resilienceSpecification, callable);
    }

    public static boolean matchesHttpCode(Either<? extends Throwable, ?> e, Response.Status status) {
        if (e.isRight()) {
            return false;
        }
        Throwable throwable = e.getLeft();
        return throwable instanceof HttpStatusExceptionSupport && ((HttpStatusExceptionSupport)throwable).getHttpStatusCode() == status.getStatusCode();
    }

    public static class DecorateCallableApi<T> {
        private final ExchangeSpecification.ResilienceSpecification resilienceSpecification;
        private CallableApi<T> callable;

        private DecorateCallableApi(ExchangeSpecification.ResilienceSpecification resilienceSpecification, CallableApi<T> callable) {
            this.resilienceSpecification = resilienceSpecification;
            this.callable = callable;
        }

        public DecorateCallableApi<T> withRetry(Retry retryContext) {
            if (this.resilienceSpecification.isRetryEnabled()) {
                this.callable = CallableApi.wrapCallable(Retry.decorateCallable(retryContext, this.callable));
            }
            return this;
        }

        public DecorateCallableApi<T> withRateLimiter(RateLimiter rateLimiter) {
            if (this.resilienceSpecification.isRateLimiterEnabled()) {
                return this.withRateLimiter(rateLimiter, 1);
            }
            return this;
        }

        public DecorateCallableApi<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            if (this.resilienceSpecification.isRateLimiterEnabled()) {
                this.callable = CallableApi.wrapCallable(RateLimiter.decorateCallable(rateLimiter, permits, this.callable));
            }
            return this;
        }

        public T call() throws IOException {
            return this.callable.call();
        }
    }

    public static interface CallableApi<T>
    extends Callable<T> {
        @Override
        public T call() throws IOException;

        public static <T> CallableApi<T> wrapCallable(Callable<T> callable) {
            return () -> {
                try {
                    return callable.call();
                }
                catch (IOException | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            };
        }
    }
}

