/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.RuntimeTransformException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.xslt.SourceHandlerFactory;
import org.apache.camel.support.builder.xml.XMLConverterHelper;
import org.w3c.dom.Node;

public class XmlSourceHandlerFactoryImpl
implements SourceHandlerFactory {
    private XMLConverterHelper converter = new XMLConverterHelper();
    private boolean isFailOnNullBody = true;

    public boolean isFailOnNullBody() {
        return this.isFailOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.isFailOnNullBody = failOnNullBody;
    }

    @Override
    public Source getSource(Exchange exchange) throws Exception {
        if (this.isInputStreamNeeded(exchange)) {
            InputStream is = exchange.getIn().getBody(InputStream.class);
            return this.getSource(exchange, is);
        }
        Object body = exchange.getIn().getBody();
        return this.getSource(exchange, body);
    }

    protected boolean isInputStreamNeeded(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (body == null) {
            return false;
        }
        if (body instanceof InputStream) {
            return true;
        }
        if (body instanceof Source) {
            return false;
        }
        if (body instanceof String) {
            return false;
        }
        if (body instanceof byte[]) {
            return false;
        }
        if (body instanceof Node) {
            return false;
        }
        return exchange.getContext().getTypeConverterRegistry().lookup(Source.class, body.getClass()) == null;
    }

    protected Source getSource(Exchange exchange, Object body) {
        if (body instanceof Source) {
            return (Source)body;
        }
        Source source = null;
        if (body != null) {
            TypeConverter tc;
            source = exchange.getContext().getTypeConverter().tryConvertTo(SAXSource.class, exchange, body);
            if (source == null) {
                source = exchange.getContext().getTypeConverter().tryConvertTo(StreamSource.class, exchange, body);
            }
            if (source == null) {
                source = exchange.getContext().getTypeConverter().tryConvertTo(DOMSource.class, exchange, body);
            }
            if (source == null && (tc = exchange.getContext().getTypeConverterRegistry().lookup(Source.class, body.getClass())) != null) {
                source = tc.convertTo(Source.class, exchange, body);
            }
        }
        if (source == null) {
            if (this.isFailOnNullBody()) {
                throw new ExpectedBodyTypeException(exchange, Source.class);
            }
            try {
                source = this.converter.toDOMSource(this.converter.createDocument());
            }
            catch (ParserConfigurationException | TransformerException e) {
                throw new RuntimeTransformException(e);
            }
        }
        return source;
    }
}

