/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.StringHelper;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppPrivateChatProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(XmppPrivateChatProducer.class);
    private final XmppEndpoint endpoint;
    private XMPPTCPConnection connection;
    private final String participant;

    public XmppPrivateChatProducer(XmppEndpoint endpoint, String participant) {
        super(endpoint);
        this.endpoint = endpoint;
        this.participant = participant;
        StringHelper.notEmpty(participant, "participant");
        LOG.debug("Creating XmppPrivateChatProducer to participant {}", (Object)participant);
    }

    @Override
    public void process(Exchange exchange) {
        try {
            if (this.connection == null) {
                this.connection = this.endpoint.createConnection();
            }
            if (!this.connection.isConnected()) {
                this.reconnect();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeCamelException("Interrupted while connecting to XMPP server.", e);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not connect to XMPP server.", e);
        }
        String participant = this.endpoint.getParticipant();
        Object thread = this.endpoint.getChatId();
        if (participant == null) {
            participant = this.getParticipant();
        } else {
            thread = "Chat:" + participant + ":" + this.endpoint.getUser();
        }
        Message message = new Message();
        try {
            message.setTo(JidCreate.from(participant));
            message.setThread((String)thread);
            message.setType(Message.Type.normal);
            ChatManager chatManager = ChatManager.getInstanceFor(this.connection);
            Chat chat = this.getOrCreateChat(chatManager, participant);
            this.endpoint.getBinding().populateXmppMessage(message, exchange);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending XMPP message to {} from {} : {}", new Object[]{participant, this.endpoint.getUser(), message.getBody()});
            }
            chat.send(message);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeExchangeException("Interrupted while sending XMPP message to " + participant + " from " + this.endpoint.getUser() + " : " + String.valueOf(message) + " to: " + XmppEndpoint.getConnectionMessage(this.connection), exchange, e);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Could not send XMPP message to " + participant + " from " + this.endpoint.getUser() + " : " + String.valueOf(message) + " to: " + XmppEndpoint.getConnectionMessage(this.connection), exchange, e);
        }
    }

    private Chat getOrCreateChat(ChatManager chatManager, String participant) throws XmppStringprepException {
        return chatManager.chatWith(JidCreate.entityBareFrom(participant));
    }

    private synchronized void reconnect() throws InterruptedException, IOException, SmackException, XMPPException {
        if (!this.connection.isConnected()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reconnecting to: {}", (Object)XmppEndpoint.getConnectionMessage(this.connection));
            }
            this.connection.connect();
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.connection == null) {
            try {
                this.connection = this.endpoint.createConnection();
            }
            catch (SmackException e) {
                if (this.endpoint.isTestConnectionOnStartup()) {
                    throw new RuntimeCamelException("Could not establish connection to XMPP server: " + this.endpoint.getConnectionDescription(), e);
                }
                LOG.warn("Could not connect to XMPP server: {} Producer will attempt lazy connection when needed.", (Object)e.getMessage());
            }
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.connection = null;
        super.doStop();
    }

    public String getParticipant() {
        return this.participant;
    }
}

