/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.chatstates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.chat2.OutgoingChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromTypeFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.chatstates.ChatState;
import org.jivesoftware.smackx.chatstates.ChatStateListener;
import org.jivesoftware.smackx.chatstates.packet.ChatStateExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;

public final class ChatStateManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ChatStateManager.class.getName());
    public static final String NAMESPACE = "http://jabber.org/protocol/chatstates";
    private static final Map<XMPPConnection, ChatStateManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatStateManager>();
    private static final StanzaFilter filter = new NotFilter(new StanzaExtensionFilter("http://jabber.org/protocol/chatstates"));
    private static final StanzaFilter INCOMING_MESSAGE_FILTER = new AndFilter(MessageTypeFilter.NORMAL_OR_CHAT, FromTypeFilter.ENTITY_FULL_JID);
    private static final StanzaFilter INCOMING_CHAT_STATE_FILTER = new AndFilter(INCOMING_MESSAGE_FILTER, new StanzaExtensionFilter("http://jabber.org/protocol/chatstates"));
    private final Set<ChatStateListener> chatStateListeners = new HashSet<ChatStateListener>();
    private final Map<Chat, ChatState> chatStates = new WeakHashMap<Chat, ChatState>();
    private final AsyncButOrdered<Chat> asyncButOrdered = new AsyncButOrdered();

    public static synchronized ChatStateManager getInstance(XMPPConnection connection) {
        ChatStateManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new ChatStateManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    private ChatStateManager(XMPPConnection connection) {
        super(connection);
        ChatManager chatManager = ChatManager.getInstanceFor(connection);
        chatManager.addOutgoingListener(new OutgoingChatMessageListener(){

            @Override
            public void newOutgoingMessage(EntityBareJid to, Message message, Chat chat) {
                if (chat == null) {
                    return;
                }
                if (!filter.accept(message)) {
                    return;
                }
                if (ChatStateManager.this.updateChatState(chat, ChatState.active)) {
                    message.addExtension(new ChatStateExtension(ChatState.active));
                }
            }
        });
        connection.addSyncStanzaListener(new StanzaListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processStanza(Stanza stanza) {
                ArrayList listeners;
                ChatState state;
                final Message message = (Message)stanza;
                EntityFullJid fullFrom = message.getFrom().asEntityFullJidIfPossible();
                EntityBareJid bareFrom = fullFrom.asEntityBareJid();
                final Chat chat = ChatManager.getInstanceFor(ChatStateManager.this.connection()).chatWith(bareFrom);
                ExtensionElement extension = message.getExtension(ChatStateManager.NAMESPACE);
                String chatStateElementName = extension.getElementName();
                try {
                    state = ChatState.valueOf(chatStateElementName);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Invalid chat state element name: " + chatStateElementName, ex);
                    return;
                }
                final ChatState finalState = state;
                Set set = ChatStateManager.this.chatStateListeners;
                synchronized (set) {
                    listeners = new ArrayList(ChatStateManager.this.chatStateListeners.size());
                    listeners.addAll(ChatStateManager.this.chatStateListeners);
                }
                final ArrayList finalListeners = listeners;
                ChatStateManager.this.asyncButOrdered.performAsyncButOrdered(chat, new Runnable(){

                    @Override
                    public void run() {
                        for (ChatStateListener listener : finalListeners) {
                            listener.stateChanged(chat, finalState, message);
                        }
                    }
                });
            }
        }, INCOMING_CHAT_STATE_FILTER);
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature(NAMESPACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChatStateListener(ChatStateListener listener) {
        Set<ChatStateListener> set = this.chatStateListeners;
        synchronized (set) {
            return this.chatStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChatStateListener(ChatStateListener listener) {
        Set<ChatStateListener> set = this.chatStateListeners;
        synchronized (set) {
            return this.chatStateListeners.remove(listener);
        }
    }

    public void setCurrentState(ChatState newState, Chat chat) throws SmackException.NotConnectedException, InterruptedException {
        if (chat == null || newState == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (!this.updateChatState(chat, newState)) {
            return;
        }
        Message message = new Message();
        ChatStateExtension extension = new ChatStateExtension(newState);
        message.addExtension(extension);
        chat.send(message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatStateManager that = (ChatStateManager)o;
        return this.connection().equals(that.connection());
    }

    public int hashCode() {
        return this.connection().hashCode();
    }

    private synchronized boolean updateChatState(Chat chat, ChatState newState) {
        ChatState lastChatState = this.chatStates.get(chat);
        if (lastChatState != newState) {
            this.chatStates.put(chat, newState);
            return true;
        }
        return false;
    }
}

