/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.muc.provider.MUCParserUtils;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MUCUserProvider
extends ExtensionElementProvider<MUCUser> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MUCUser parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
        MUCUser mucUser = new MUCUser();
        while (true) {
            block0 : switch (parser.next()) {
                case 2: {
                    switch (parser.getName()) {
                        case "invite": {
                            mucUser.setInvite(MUCUserProvider.parseInvite(parser));
                            break block0;
                        }
                        case "item": {
                            mucUser.setItem(MUCParserUtils.parseItem(parser));
                            break block0;
                        }
                        case "password": {
                            mucUser.setPassword(parser.nextText());
                            break block0;
                        }
                        case "status": {
                            String statusString = parser.getAttributeValue("", "code");
                            mucUser.addStatusCode(MUCUser.Status.create(statusString));
                            break block0;
                        }
                        case "decline": {
                            mucUser.setDecline(MUCUserProvider.parseDecline(parser));
                            break block0;
                        }
                        case "destroy": {
                            mucUser.setDestroy(MUCParserUtils.parseDestroy(parser));
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return mucUser;
                }
            }
        }
    }

    private static MUCUser.Invite parseInvite(XmlPullParser parser) throws XmlPullParserException, IOException {
        String reason = null;
        EntityBareJid to = ParserUtils.getBareJidAttribute(parser, "to");
        EntityJid from = ParserUtils.getEntityJidAttribute(parser, "from");
        while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2) {
                if (!parser.getName().equals("reason")) continue;
                reason = parser.nextText();
                continue;
            }
            if (eventType == 3 && parser.getName().equals("invite")) break;
        }
        return new MUCUser.Invite(reason, from, to);
    }

    private static MUCUser.Decline parseDecline(XmlPullParser parser) throws XmlPullParserException, IOException {
        String reason = null;
        EntityBareJid to = ParserUtils.getBareJidAttribute(parser, "to");
        EntityBareJid from = ParserUtils.getBareJidAttribute(parser, "from");
        while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2) {
                if (!parser.getName().equals("reason")) continue;
                reason = parser.nextText();
                continue;
            }
            if (eventType == 3 && parser.getName().equals("decline")) break;
        }
        return new MUCUser.Decline(reason, from, to);
    }
}

