/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SimplePayload
implements ExtensionElement {
    private final String elemName;
    private final String ns;
    private final String payload;

    public SimplePayload(String xmlPayload) {
        XmlPullParser parser;
        try {
            parser = PacketParserUtils.getParserFor(xmlPayload);
        }
        catch (IOException | XmlPullParserException e) {
            throw new AssertionError((Object)e);
        }
        QName qname = ParserUtils.getQName(parser);
        this.payload = xmlPayload;
        this.elemName = StringUtils.requireNotNullOrEmpty(qname.getLocalPart(), "Could not determine element name from XML payload");
        this.ns = StringUtils.requireNotNullOrEmpty(qname.getNamespaceURI(), "Could not determine namespace from XML payload");
    }

    @Deprecated
    public SimplePayload(String elementName, String namespace, CharSequence xmlPayload) {
        this(xmlPayload.toString());
        if (!elementName.equals(this.elemName)) {
            throw new IllegalArgumentException();
        }
        if (!namespace.equals(this.ns)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getElementName() {
        return this.elemName;
    }

    @Override
    public String getNamespace() {
        return this.ns;
    }

    @Override
    public String toXML(String enclosingNamespace) {
        return this.payload;
    }

    public String toString() {
        return this.getClass().getName() + "payload [" + this.toXML(null) + "]";
    }
}

