/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smackx.muc.MucEnterConfiguration;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppGroupChatProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(XmppGroupChatProducer.class);
    private final XmppEndpoint endpoint;
    private XMPPTCPConnection connection;
    private MultiUserChat chat;
    private String room;

    public XmppGroupChatProducer(XmppEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) {
        if (this.connection == null) {
            try {
                this.connection = this.endpoint.createConnection();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeExchangeException("Interrupted while connecting to XMPP server.", exchange, e);
            }
            catch (Exception e) {
                throw new RuntimeExchangeException("Could not connect to XMPP server.", exchange, e);
            }
        }
        if (this.chat == null) {
            try {
                this.initializeChat();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeExchangeException("Interrupted while initializing XMPP chat.", exchange, e);
            }
            catch (Exception e) {
                throw new RuntimeExchangeException("Could not initialize XMPP chat.", exchange, e);
            }
        }
        Message message = this.chat.createMessage();
        try {
            message.setTo(JidCreate.from(this.room));
            message.setFrom(JidCreate.from(this.endpoint.getUser()));
            this.endpoint.getBinding().populateXmppMessage(message, exchange);
            if (!this.connection.isConnected()) {
                this.reconnect();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending XMPP message: {}", (Object)message.getBody());
            }
            this.chat.sendMessage(message);
            this.chat.pollMessage();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeExchangeException("Interrupted while sending XMPP message: " + String.valueOf(message), exchange, e);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Could not send XMPP message: " + String.valueOf(message), exchange, e);
        }
    }

    private synchronized void reconnect() throws InterruptedException, IOException, SmackException, XMPPException {
        if (!this.connection.isConnected()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reconnecting to: {}", (Object)XmppEndpoint.getConnectionMessage(this.connection));
            }
            this.connection.connect();
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.connection == null) {
            try {
                this.connection = this.endpoint.createConnection();
            }
            catch (SmackException e) {
                if (this.endpoint.isTestConnectionOnStartup()) {
                    throw new RuntimeCamelException("Could not connect to XMPP server:  " + this.endpoint.getConnectionDescription(), e);
                }
                LOG.warn("Could not connect to XMPP server. {}  Producer will attempt lazy connection when needed.", (Object)e.getMessage());
            }
        }
        if (this.chat == null && this.connection != null) {
            this.initializeChat();
        }
        super.doStart();
    }

    protected synchronized void initializeChat() throws InterruptedException, SmackException, XMPPException, XmppStringprepException {
        if (this.chat == null) {
            this.room = this.endpoint.resolveRoom(this.connection);
            String roomPassword = this.endpoint.getRoomPassword();
            MultiUserChatManager chatManager = MultiUserChatManager.getInstanceFor(this.connection);
            this.chat = chatManager.getMultiUserChat(JidCreate.entityBareFrom(this.room));
            MucEnterConfiguration.Builder mucc = this.chat.getEnterConfigurationBuilder(Resourcepart.from(this.endpoint.getNickname())).requestNoHistory();
            if (roomPassword != null) {
                mucc.withPassword(roomPassword);
            }
            this.chat.join(mucc.build());
            LOG.info("Joined room: {} as: {}", (Object)this.room, (Object)this.endpoint.getNickname());
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.chat != null) {
            LOG.info("Leaving room: {}", (Object)this.room);
            this.chat.leave();
        }
        this.chat = null;
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.connection = null;
        super.doStop();
    }

    public String getRoom() {
        return this.room;
    }
}

