/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;
import org.jxmpp.jid.EntityJid;

@Deprecated
public class Chat {
    private final ChatManager chatManager;
    private final String threadID;
    private final EntityJid participant;
    private final Set<ChatMessageListener> listeners = new CopyOnWriteArraySet<ChatMessageListener>();

    Chat(ChatManager chatManager, EntityJid participant, String threadID) {
        if (StringUtils.isEmpty(threadID)) {
            throw new IllegalArgumentException("Thread ID must not be null");
        }
        this.chatManager = chatManager;
        this.participant = participant;
        this.threadID = threadID;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public EntityJid getParticipant() {
        return this.participant;
    }

    public void sendMessage(String text) throws SmackException.NotConnectedException, InterruptedException {
        Message message = new Message();
        message.setBody(text);
        this.sendMessage(message);
    }

    public void sendMessage(Message message) throws SmackException.NotConnectedException, InterruptedException {
        message.setTo(this.participant);
        message.setType(Message.Type.chat);
        message.setThread(this.threadID);
        this.chatManager.sendMessage(this, message);
    }

    public void addMessageListener(ChatMessageListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeMessageListener(ChatMessageListener listener) {
        this.listeners.remove(listener);
    }

    public void close() {
        this.chatManager.closeChat(this);
        this.listeners.clear();
    }

    public Set<ChatMessageListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public StanzaCollector createCollector() {
        return this.chatManager.createStanzaCollector(this);
    }

    void deliver(Message message) {
        message.setThread(this.threadID);
        for (ChatMessageListener listener : this.listeners) {
            listener.processMessage(this, message);
        }
    }

    public String toString() {
        return "Chat [(participant=" + this.participant + "), (thread=" + this.threadID + ")]";
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.threadID.hashCode();
        hash = hash * 31 + this.participant.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        return obj instanceof Chat && this.threadID.equals(((Chat)obj).getThreadID()) && this.participant.equals(((Chat)obj).getParticipant());
    }
}

