/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManagerListener;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FlexibleStanzaTypeFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;

@Deprecated
public final class ChatManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ChatManager.class.getName());
    private static final Map<XMPPConnection, ChatManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatManager>();
    private static boolean defaultIsNormalInclude = true;
    private static MatchMode defaultMatchMode = MatchMode.BARE_JID;
    private final StanzaFilter packetFilter = new OrFilter(MessageTypeFilter.CHAT, new FlexibleStanzaTypeFilter<Message>(){

        @Override
        protected boolean acceptSpecific(Message message) {
            return ChatManager.this.normalIncluded ? message.getType() == Message.Type.normal : false;
        }
    });
    private boolean normalIncluded = defaultIsNormalInclude;
    private MatchMode matchMode = defaultMatchMode;
    private final Map<String, Chat> threadChats = new ConcurrentHashMap<String, Chat>();
    private final Map<Jid, Chat> jidChats = new ConcurrentHashMap<Jid, Chat>();
    private final Map<EntityBareJid, Chat> baseJidChats = new ConcurrentHashMap<EntityBareJid, Chat>();
    private final Set<ChatManagerListener> chatManagerListeners = new CopyOnWriteArraySet<ChatManagerListener>();
    private final Map<MessageListener, StanzaFilter> interceptors = new WeakHashMap<MessageListener, StanzaFilter>();

    public static synchronized ChatManager getInstanceFor(XMPPConnection connection) {
        ChatManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new ChatManager(connection);
        }
        return manager;
    }

    private ChatManager(XMPPConnection connection) {
        super(connection);
        connection.addSyncStanzaListener(new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Message message = (Message)packet;
                Chat chat = message.getThread() == null ? ChatManager.this.getUserChat(message.getFrom()) : ChatManager.this.getThreadChat(message.getThread());
                if (chat == null) {
                    chat = ChatManager.this.createChat(message);
                }
                if (chat == null) {
                    return;
                }
                ChatManager.deliverMessage(chat, message);
            }
        }, this.packetFilter);
        INSTANCES.put(connection, this);
    }

    public boolean isNormalIncluded() {
        return this.normalIncluded;
    }

    public void setNormalIncluded(boolean normalIncluded) {
        this.normalIncluded = normalIncluded;
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(MatchMode matchMode) {
        this.matchMode = matchMode;
    }

    public Chat createChat(EntityJid userJID) {
        return this.createChat(userJID, null);
    }

    public Chat createChat(EntityJid userJID, ChatMessageListener listener) {
        return this.createChat(userJID, null, listener);
    }

    public Chat createChat(EntityJid userJID, String thread, ChatMessageListener listener) {
        Chat chat;
        if (thread == null) {
            thread = ChatManager.nextID();
        }
        if ((chat = this.threadChats.get(thread)) != null) {
            throw new IllegalArgumentException("ThreadID is already used");
        }
        chat = this.createChat(userJID, thread, true);
        chat.addMessageListener(listener);
        return chat;
    }

    private Chat createChat(EntityJid userJID, String threadID, boolean createdLocally) {
        Chat chat = new Chat(this, userJID, threadID);
        this.threadChats.put(threadID, chat);
        this.jidChats.put(userJID, chat);
        this.baseJidChats.put(userJID.asEntityBareJid(), chat);
        for (ChatManagerListener listener : this.chatManagerListeners) {
            listener.chatCreated(chat, createdLocally);
        }
        return chat;
    }

    void closeChat(Chat chat) {
        this.threadChats.remove(chat.getThreadID());
        EntityJid userJID = chat.getParticipant();
        this.jidChats.remove(userJID);
        this.baseJidChats.remove(userJID.asEntityBareJid());
    }

    private Chat createChat(Message message) {
        Jid from = message.getFrom();
        if (from == null) {
            return null;
        }
        EntityJid userJID = from.asEntityJidIfPossible();
        if (userJID == null) {
            LOGGER.warning("Message from JID without localpart: '" + message.toXML(null) + "'");
            return null;
        }
        String threadID = message.getThread();
        if (threadID == null) {
            threadID = ChatManager.nextID();
        }
        return this.createChat(userJID, threadID, false);
    }

    private Chat getUserChat(Jid userJID) {
        EntityBareJid entityBareJid;
        if (this.matchMode == MatchMode.NONE) {
            return null;
        }
        if (userJID == null) {
            return null;
        }
        Chat match = this.jidChats.get(userJID);
        if (match == null && this.matchMode == MatchMode.BARE_JID && (entityBareJid = userJID.asEntityBareJidIfPossible()) != null) {
            match = this.baseJidChats.get(entityBareJid);
        }
        return match;
    }

    public Chat getThreadChat(String thread) {
        return this.threadChats.get(thread);
    }

    public void addChatListener(ChatManagerListener listener) {
        this.chatManagerListeners.add(listener);
    }

    public void removeChatListener(ChatManagerListener listener) {
        this.chatManagerListeners.remove(listener);
    }

    public Set<ChatManagerListener> getChatListeners() {
        return Collections.unmodifiableSet(this.chatManagerListeners);
    }

    private static void deliverMessage(Chat chat, Message message) {
        chat.deliver(message);
    }

    void sendMessage(Chat chat, Message message) throws SmackException.NotConnectedException, InterruptedException {
        for (Map.Entry<MessageListener, StanzaFilter> interceptor : this.interceptors.entrySet()) {
            StanzaFilter filter = interceptor.getValue();
            if (filter == null || !filter.accept(message)) continue;
            interceptor.getKey().processMessage(message);
        }
        this.connection().sendStanza(message);
    }

    StanzaCollector createStanzaCollector(Chat chat) {
        return this.connection().createStanzaCollector(new AndFilter(new ThreadFilter(chat.getThreadID()), FromMatchesFilter.create(chat.getParticipant())));
    }

    public void addOutgoingMessageInterceptor(MessageListener messageInterceptor) {
        this.addOutgoingMessageInterceptor(messageInterceptor, null);
    }

    public void addOutgoingMessageInterceptor(MessageListener messageInterceptor, StanzaFilter filter) {
        if (messageInterceptor == null) {
            return;
        }
        this.interceptors.put(messageInterceptor, filter);
    }

    private static String nextID() {
        return UUID.randomUUID().toString();
    }

    public static void setDefaultMatchMode(MatchMode mode) {
        defaultMatchMode = mode;
    }

    public static void setDefaultIsNormalIncluded(boolean allowNormal) {
        defaultIsNormalInclude = allowNormal;
    }

    public static enum MatchMode {
        NONE,
        SUPPLIED_JID,
        BARE_JID;

    }
}

